<?php 
/**
 * Jadwal_maret Page Controller
 * @category  Controller
 */
class Jadwal_maretController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "jadwal_maret";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("id", 
			"nama", 
			"nip", 
			"tgl_1", 
			"tgl_2", 
			"tgl_3", 
			"tgl_4", 
			"tgl_5", 
			"tgl_6", 
			"tgl_7", 
			"tgl_8", 
			"tgl_9", 
			"tgl_10", 
			"tgl_11", 
			"tgl_12", 
			"tgl_13", 
			"tgl_14", 
			"tgl_15", 
			"tgl_16", 
			"tgl_17", 
			"tgl_18", 
			"tgl_19", 
			"tgl_20", 
			"tgl_21", 
			"tgl_22", 
			"tgl_23", 
			"tgl_24", 
			"tgl_25", 
			"tgl_26", 
			"tgl_27", 
			"tgl_28", 
			"tgl_29", 
			"tgl_30", 
			"tgl_31");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				jadwal_maret.id LIKE ? OR 
				jadwal_maret.nama LIKE ? OR 
				jadwal_maret.nip LIKE ? OR 
				jadwal_maret.tgl_1 LIKE ? OR 
				jadwal_maret.tgl_2 LIKE ? OR 
				jadwal_maret.tgl_3 LIKE ? OR 
				jadwal_maret.tgl_4 LIKE ? OR 
				jadwal_maret.tgl_5 LIKE ? OR 
				jadwal_maret.tgl_6 LIKE ? OR 
				jadwal_maret.tgl_7 LIKE ? OR 
				jadwal_maret.tgl_8 LIKE ? OR 
				jadwal_maret.tgl_9 LIKE ? OR 
				jadwal_maret.tgl_10 LIKE ? OR 
				jadwal_maret.tgl_11 LIKE ? OR 
				jadwal_maret.tgl_12 LIKE ? OR 
				jadwal_maret.tgl_13 LIKE ? OR 
				jadwal_maret.tgl_14 LIKE ? OR 
				jadwal_maret.tgl_15 LIKE ? OR 
				jadwal_maret.tgl_16 LIKE ? OR 
				jadwal_maret.tgl_17 LIKE ? OR 
				jadwal_maret.tgl_18 LIKE ? OR 
				jadwal_maret.tgl_19 LIKE ? OR 
				jadwal_maret.tgl_20 LIKE ? OR 
				jadwal_maret.tgl_21 LIKE ? OR 
				jadwal_maret.tgl_22 LIKE ? OR 
				jadwal_maret.tgl_23 LIKE ? OR 
				jadwal_maret.tgl_24 LIKE ? OR 
				jadwal_maret.tgl_25 LIKE ? OR 
				jadwal_maret.tgl_26 LIKE ? OR 
				jadwal_maret.tgl_27 LIKE ? OR 
				jadwal_maret.tgl_28 LIKE ? OR 
				jadwal_maret.tgl_29 LIKE ? OR 
				jadwal_maret.tgl_30 LIKE ? OR 
				jadwal_maret.tgl_31 LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "jadwal_maret/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("jadwal_maret.id", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Jadwal Maret";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		$this->render_view("jadwal_maret/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("id", 
			"nama", 
			"nip", 
			"tgl_1", 
			"tgl_2", 
			"tgl_3", 
			"tgl_4", 
			"tgl_5", 
			"tgl_6", 
			"tgl_7", 
			"tgl_8", 
			"tgl_9", 
			"tgl_10", 
			"tgl_11", 
			"tgl_12", 
			"tgl_13", 
			"tgl_14", 
			"tgl_15", 
			"tgl_16", 
			"tgl_17", 
			"tgl_18", 
			"tgl_19", 
			"tgl_20", 
			"tgl_21", 
			"tgl_22", 
			"tgl_23", 
			"tgl_24", 
			"tgl_25", 
			"tgl_26", 
			"tgl_27", 
			"tgl_28", 
			"tgl_29", 
			"tgl_30", 
			"tgl_31");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("jadwal_maret.id", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Jadwal Maret";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("jadwal_maret/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("nama","nip","tgl_1","tgl_2","tgl_3","tgl_4","tgl_5","tgl_6","tgl_7","tgl_8","tgl_9","tgl_10","tgl_11","tgl_12","tgl_13","tgl_14","tgl_15","tgl_16","tgl_17","tgl_18","tgl_19","tgl_20","tgl_21","tgl_22","tgl_23","tgl_24","tgl_25","tgl_26","tgl_27","tgl_28","tgl_29","tgl_30","tgl_31");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'nama' => 'required',
				'nip' => 'required',
				'tgl_1' => 'required',
				'tgl_2' => 'required',
				'tgl_3' => 'required',
				'tgl_4' => 'required',
				'tgl_5' => 'required',
				'tgl_6' => 'required',
				'tgl_7' => 'required',
				'tgl_8' => 'required',
				'tgl_9' => 'required',
				'tgl_10' => 'required',
				'tgl_11' => 'required',
				'tgl_12' => 'required',
				'tgl_13' => 'required',
				'tgl_14' => 'required',
				'tgl_15' => 'required',
				'tgl_16' => 'required',
				'tgl_17' => 'required',
				'tgl_18' => 'required',
				'tgl_19' => 'required',
				'tgl_20' => 'required',
				'tgl_21' => 'required',
				'tgl_22' => 'required',
				'tgl_23' => 'required',
				'tgl_24' => 'required',
				'tgl_25' => 'required',
				'tgl_26' => 'required',
				'tgl_27' => 'required',
				'tgl_28' => 'required',
				'tgl_29' => 'required',
				'tgl_30' => 'required',
				'tgl_31' => 'required',
			);
			$this->sanitize_array = array(
				'nama' => 'sanitize_string',
				'nip' => 'sanitize_string',
				'tgl_1' => 'sanitize_string',
				'tgl_2' => 'sanitize_string',
				'tgl_3' => 'sanitize_string',
				'tgl_4' => 'sanitize_string',
				'tgl_5' => 'sanitize_string',
				'tgl_6' => 'sanitize_string',
				'tgl_7' => 'sanitize_string',
				'tgl_8' => 'sanitize_string',
				'tgl_9' => 'sanitize_string',
				'tgl_10' => 'sanitize_string',
				'tgl_11' => 'sanitize_string',
				'tgl_12' => 'sanitize_string',
				'tgl_13' => 'sanitize_string',
				'tgl_14' => 'sanitize_string',
				'tgl_15' => 'sanitize_string',
				'tgl_16' => 'sanitize_string',
				'tgl_17' => 'sanitize_string',
				'tgl_18' => 'sanitize_string',
				'tgl_19' => 'sanitize_string',
				'tgl_20' => 'sanitize_string',
				'tgl_21' => 'sanitize_string',
				'tgl_22' => 'sanitize_string',
				'tgl_23' => 'sanitize_string',
				'tgl_24' => 'sanitize_string',
				'tgl_25' => 'sanitize_string',
				'tgl_26' => 'sanitize_string',
				'tgl_27' => 'sanitize_string',
				'tgl_28' => 'sanitize_string',
				'tgl_29' => 'sanitize_string',
				'tgl_30' => 'sanitize_string',
				'tgl_31' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("jadwal_maret");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Jadwal Maret";
		$this->render_view("jadwal_maret/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("id","nama","nip","tgl_1","tgl_2","tgl_3","tgl_4","tgl_5","tgl_6","tgl_7","tgl_8","tgl_9","tgl_10","tgl_11","tgl_12","tgl_13","tgl_14","tgl_15","tgl_16","tgl_17","tgl_18","tgl_19","tgl_20","tgl_21","tgl_22","tgl_23","tgl_24","tgl_25","tgl_26","tgl_27","tgl_28","tgl_29","tgl_30","tgl_31");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'nama' => 'required',
				'nip' => 'required',
				'tgl_1' => 'required',
				'tgl_2' => 'required',
				'tgl_3' => 'required',
				'tgl_4' => 'required',
				'tgl_5' => 'required',
				'tgl_6' => 'required',
				'tgl_7' => 'required',
				'tgl_8' => 'required',
				'tgl_9' => 'required',
				'tgl_10' => 'required',
				'tgl_11' => 'required',
				'tgl_12' => 'required',
				'tgl_13' => 'required',
				'tgl_14' => 'required',
				'tgl_15' => 'required',
				'tgl_16' => 'required',
				'tgl_17' => 'required',
				'tgl_18' => 'required',
				'tgl_19' => 'required',
				'tgl_20' => 'required',
				'tgl_21' => 'required',
				'tgl_22' => 'required',
				'tgl_23' => 'required',
				'tgl_24' => 'required',
				'tgl_25' => 'required',
				'tgl_26' => 'required',
				'tgl_27' => 'required',
				'tgl_28' => 'required',
				'tgl_29' => 'required',
				'tgl_30' => 'required',
				'tgl_31' => 'required',
			);
			$this->sanitize_array = array(
				'nama' => 'sanitize_string',
				'nip' => 'sanitize_string',
				'tgl_1' => 'sanitize_string',
				'tgl_2' => 'sanitize_string',
				'tgl_3' => 'sanitize_string',
				'tgl_4' => 'sanitize_string',
				'tgl_5' => 'sanitize_string',
				'tgl_6' => 'sanitize_string',
				'tgl_7' => 'sanitize_string',
				'tgl_8' => 'sanitize_string',
				'tgl_9' => 'sanitize_string',
				'tgl_10' => 'sanitize_string',
				'tgl_11' => 'sanitize_string',
				'tgl_12' => 'sanitize_string',
				'tgl_13' => 'sanitize_string',
				'tgl_14' => 'sanitize_string',
				'tgl_15' => 'sanitize_string',
				'tgl_16' => 'sanitize_string',
				'tgl_17' => 'sanitize_string',
				'tgl_18' => 'sanitize_string',
				'tgl_19' => 'sanitize_string',
				'tgl_20' => 'sanitize_string',
				'tgl_21' => 'sanitize_string',
				'tgl_22' => 'sanitize_string',
				'tgl_23' => 'sanitize_string',
				'tgl_24' => 'sanitize_string',
				'tgl_25' => 'sanitize_string',
				'tgl_26' => 'sanitize_string',
				'tgl_27' => 'sanitize_string',
				'tgl_28' => 'sanitize_string',
				'tgl_29' => 'sanitize_string',
				'tgl_30' => 'sanitize_string',
				'tgl_31' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jadwal_maret.id", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("jadwal_maret");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("jadwal_maret");
					}
				}
			}
		}
		$db->where("jadwal_maret.id", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Jadwal Maret";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("jadwal_maret/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("id","nama","nip","tgl_1","tgl_2","tgl_3","tgl_4","tgl_5","tgl_6","tgl_7","tgl_8","tgl_9","tgl_10","tgl_11","tgl_12","tgl_13","tgl_14","tgl_15","tgl_16","tgl_17","tgl_18","tgl_19","tgl_20","tgl_21","tgl_22","tgl_23","tgl_24","tgl_25","tgl_26","tgl_27","tgl_28","tgl_29","tgl_30","tgl_31");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'nama' => 'required',
				'nip' => 'required',
				'tgl_1' => 'required',
				'tgl_2' => 'required',
				'tgl_3' => 'required',
				'tgl_4' => 'required',
				'tgl_5' => 'required',
				'tgl_6' => 'required',
				'tgl_7' => 'required',
				'tgl_8' => 'required',
				'tgl_9' => 'required',
				'tgl_10' => 'required',
				'tgl_11' => 'required',
				'tgl_12' => 'required',
				'tgl_13' => 'required',
				'tgl_14' => 'required',
				'tgl_15' => 'required',
				'tgl_16' => 'required',
				'tgl_17' => 'required',
				'tgl_18' => 'required',
				'tgl_19' => 'required',
				'tgl_20' => 'required',
				'tgl_21' => 'required',
				'tgl_22' => 'required',
				'tgl_23' => 'required',
				'tgl_24' => 'required',
				'tgl_25' => 'required',
				'tgl_26' => 'required',
				'tgl_27' => 'required',
				'tgl_28' => 'required',
				'tgl_29' => 'required',
				'tgl_30' => 'required',
				'tgl_31' => 'required',
			);
			$this->sanitize_array = array(
				'nama' => 'sanitize_string',
				'nip' => 'sanitize_string',
				'tgl_1' => 'sanitize_string',
				'tgl_2' => 'sanitize_string',
				'tgl_3' => 'sanitize_string',
				'tgl_4' => 'sanitize_string',
				'tgl_5' => 'sanitize_string',
				'tgl_6' => 'sanitize_string',
				'tgl_7' => 'sanitize_string',
				'tgl_8' => 'sanitize_string',
				'tgl_9' => 'sanitize_string',
				'tgl_10' => 'sanitize_string',
				'tgl_11' => 'sanitize_string',
				'tgl_12' => 'sanitize_string',
				'tgl_13' => 'sanitize_string',
				'tgl_14' => 'sanitize_string',
				'tgl_15' => 'sanitize_string',
				'tgl_16' => 'sanitize_string',
				'tgl_17' => 'sanitize_string',
				'tgl_18' => 'sanitize_string',
				'tgl_19' => 'sanitize_string',
				'tgl_20' => 'sanitize_string',
				'tgl_21' => 'sanitize_string',
				'tgl_22' => 'sanitize_string',
				'tgl_23' => 'sanitize_string',
				'tgl_24' => 'sanitize_string',
				'tgl_25' => 'sanitize_string',
				'tgl_26' => 'sanitize_string',
				'tgl_27' => 'sanitize_string',
				'tgl_28' => 'sanitize_string',
				'tgl_29' => 'sanitize_string',
				'tgl_30' => 'sanitize_string',
				'tgl_31' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jadwal_maret.id", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("jadwal_maret.id", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("jadwal_maret");
	}
}
