<?php 
/**
 * Pangkat Page Controller
 * @category  Controller
 */
class PangkatController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "pangkat";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("id_pangkat", 
			"nama", 
			"jenis_kelamin", 
			"tempat", 
			"tgl_lahir", 
			"nip", 
			"nik", 
			"gol_pangkat", 
			"eselon", 
			"jabatan", 
			"tmt_cpns", 
			"tmt_puskesmas", 
			"no_str", 
			"tgl_terbitstr", 
			"tgl_berlakustr", 
			"no_sip", 
			"tgl_terbitsip", 
			"tgl_berlakusip");
		$pagination = $this->get_pagination(50); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				pangkat.id_pangkat LIKE ? OR 
				pangkat.nama LIKE ? OR 
				pangkat.jenis_kelamin LIKE ? OR 
				pangkat.tempat LIKE ? OR 
				pangkat.tgl_lahir LIKE ? OR 
				pangkat.nip LIKE ? OR 
				pangkat.nik LIKE ? OR 
				pangkat.gol_pangkat LIKE ? OR 
				pangkat.eselon LIKE ? OR 
				pangkat.jabatan LIKE ? OR 
				pangkat.tmt_cpns LIKE ? OR 
				pangkat.tmt_puskesmas LIKE ? OR 
				pangkat.no_str LIKE ? OR 
				pangkat.tgl_terbitstr LIKE ? OR 
				pangkat.tgl_berlakustr LIKE ? OR 
				pangkat.no_sip LIKE ? OR 
				pangkat.tgl_terbitsip LIKE ? OR 
				pangkat.tgl_berlakusip LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "pangkat/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("id_pangkat", "ASC");
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		if(	!empty($records)){
			foreach($records as &$record){
				$record['tgl_lahir'] = format_date($record['tgl_lahir'],'d-m-Y');
$record['tmt_cpns'] = format_date($record['tmt_cpns'],'d-m-Y');
$record['tmt_puskesmas'] = format_date($record['tmt_puskesmas'],'d-m-Y');
$record['tgl_terbitstr'] = format_date($record['tgl_terbitstr'],'d-m-Y');
$record['tgl_berlakustr'] = format_date($record['tgl_berlakustr'],'d-m-Y');
$record['tgl_terbitsip'] = format_date($record['tgl_terbitsip'],'d-m-Y');
$record['tgl_berlakusip'] = format_date($record['tgl_berlakusip'],'d-m-Y');
			}
		}
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "DUK Pegawai";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		$this->render_view("pangkat/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("id_pangkat", 
			"nama", 
			"jenis_kelamin", 
			"tempat", 
			"tgl_lahir", 
			"nip", 
			"nik", 
			"gol_pangkat", 
			"eselon", 
			"jabatan", 
			"tmt_cpns", 
			"tmt_puskesmas", 
			"no_str", 
			"tgl_terbitstr", 
			"tgl_berlakustr", 
			"no_sip", 
			"tgl_terbitsip", 
			"tgl_berlakusip");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("pangkat.id_pangkat", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$record['tgl_lahir'] = format_date($record['tgl_lahir'],'d-m-Y');
$record['tmt_cpns'] = format_date($record['tmt_cpns'],'d-m-Y');
$record['tmt_puskesmas'] = format_date($record['tmt_puskesmas'],'d-m-Y');
$record['tgl_terbitstr'] = format_date($record['tgl_terbitstr'],'d-m-Y');
$record['tgl_berlakustr'] = format_date($record['tgl_berlakustr'],'d-m-Y');
$record['tgl_terbitsip'] = format_date($record['tgl_terbitsip'],'d-m-Y');
$record['tgl_berlakusip'] = format_date($record['tgl_berlakusip'],'d-m-Y');
			$page_title = $this->view->page_title = "View DUK Pegawai";
		$this->view->report_filename = date('Y-m-d') . '-' . $page_title;
		$this->view->report_title = $page_title;
		$this->view->report_layout = "report_layout.php";
		$this->view->report_paper_size = "A4";
		$this->view->report_orientation = "portrait";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("pangkat/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("nama","jenis_kelamin","tempat","tgl_lahir","nip","nik","gol_pangkat","eselon","jabatan","tmt_cpns","tmt_puskesmas","no_str","tgl_terbitstr","tgl_berlakustr","no_sip","tgl_terbitsip","tgl_berlakusip");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'nama' => 'required',
				'jenis_kelamin' => 'required',
				'tempat' => 'required',
				'tgl_lahir' => 'required',
				'nip' => 'required',
				'nik' => 'required',
				'gol_pangkat' => 'required',
				'eselon' => 'required',
				'jabatan' => 'required',
				'tmt_cpns' => 'required',
				'tmt_puskesmas' => 'required',
				'tgl_terbitsip' => 'required',
				'tgl_berlakusip' => 'required',
			);
			$this->sanitize_array = array(
				'nama' => 'sanitize_string',
				'jenis_kelamin' => 'sanitize_string',
				'tempat' => 'sanitize_string',
				'tgl_lahir' => 'sanitize_string',
				'nip' => 'sanitize_string',
				'nik' => 'sanitize_string',
				'gol_pangkat' => 'sanitize_string',
				'eselon' => 'sanitize_string',
				'jabatan' => 'sanitize_string',
				'tmt_cpns' => 'sanitize_string',
				'tmt_puskesmas' => 'sanitize_string',
				'no_str' => 'sanitize_string',
				'tgl_terbitstr' => 'sanitize_string',
				'tgl_berlakustr' => 'sanitize_string',
				'no_sip' => 'sanitize_string',
				'tgl_terbitsip' => 'sanitize_string',
				'tgl_berlakusip' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("pangkat");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Input Data Pegawai";
		$this->render_view("pangkat/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("id_pangkat","nama","jenis_kelamin","tempat","tgl_lahir","nip","nik","gol_pangkat","eselon","jabatan","tmt_cpns","tmt_puskesmas","no_str","tgl_terbitstr","tgl_berlakustr","no_sip","tgl_terbitsip","tgl_berlakusip");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'nama' => 'required',
				'jenis_kelamin' => 'required',
				'tempat' => 'required',
				'tgl_lahir' => 'required',
				'nip' => 'required',
				'nik' => 'required',
				'gol_pangkat' => 'required',
				'eselon' => 'required',
				'jabatan' => 'required',
				'tmt_cpns' => 'required',
				'tmt_puskesmas' => 'required',
				'tgl_terbitsip' => 'required',
				'tgl_berlakusip' => 'required',
			);
			$this->sanitize_array = array(
				'nama' => 'sanitize_string',
				'jenis_kelamin' => 'sanitize_string',
				'tempat' => 'sanitize_string',
				'tgl_lahir' => 'sanitize_string',
				'nip' => 'sanitize_string',
				'nik' => 'sanitize_string',
				'gol_pangkat' => 'sanitize_string',
				'eselon' => 'sanitize_string',
				'jabatan' => 'sanitize_string',
				'tmt_cpns' => 'sanitize_string',
				'tmt_puskesmas' => 'sanitize_string',
				'no_str' => 'sanitize_string',
				'tgl_terbitstr' => 'sanitize_string',
				'tgl_berlakustr' => 'sanitize_string',
				'no_sip' => 'sanitize_string',
				'tgl_terbitsip' => 'sanitize_string',
				'tgl_berlakusip' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("pangkat.id_pangkat", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("pangkat");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("pangkat");
					}
				}
			}
		}
		$db->where("pangkat.id_pangkat", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Pangkat";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("pangkat/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("id_pangkat","nama","jenis_kelamin","tempat","tgl_lahir","nip","nik","gol_pangkat","eselon","jabatan","tmt_cpns","tmt_puskesmas","no_str","tgl_terbitstr","tgl_berlakustr","no_sip","tgl_terbitsip","tgl_berlakusip");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'nama' => 'required',
				'jenis_kelamin' => 'required',
				'tempat' => 'required',
				'tgl_lahir' => 'required',
				'nip' => 'required',
				'nik' => 'required',
				'gol_pangkat' => 'required',
				'eselon' => 'required',
				'jabatan' => 'required',
				'tmt_cpns' => 'required',
				'tmt_puskesmas' => 'required',
				'tgl_terbitsip' => 'required',
				'tgl_berlakusip' => 'required',
			);
			$this->sanitize_array = array(
				'nama' => 'sanitize_string',
				'jenis_kelamin' => 'sanitize_string',
				'tempat' => 'sanitize_string',
				'tgl_lahir' => 'sanitize_string',
				'nip' => 'sanitize_string',
				'nik' => 'sanitize_string',
				'gol_pangkat' => 'sanitize_string',
				'eselon' => 'sanitize_string',
				'jabatan' => 'sanitize_string',
				'tmt_cpns' => 'sanitize_string',
				'tmt_puskesmas' => 'sanitize_string',
				'no_str' => 'sanitize_string',
				'tgl_terbitstr' => 'sanitize_string',
				'tgl_berlakustr' => 'sanitize_string',
				'no_sip' => 'sanitize_string',
				'tgl_terbitsip' => 'sanitize_string',
				'tgl_berlakusip' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("pangkat.id_pangkat", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("pangkat.id_pangkat", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("pangkat");
	}
}
