<?php
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("arsip/add");
$can_edit = ACL::is_allowed("arsip/edit");
$can_view = ACL::is_allowed("arsip/view");
$can_delete = ACL::is_allowed("arsip/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list" data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if ($show_header == true) {
    ?>
        <div class="bg-light p-3 mb-3">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col ">
                        <h4 class="record-title">Dokumen Pegawai</h4>
                    </div>
                    <div class="col-sm-3 ">
                        <?php if ($can_add) { ?>
                            <a class="btn btn btn-primary my-1" href="<?php print_link("arsip/add") ?>">
                                <i class="fa fa-plus"></i>
                                Tambah Pegawai
                            </a>
                        <?php } ?>
                    </div>
                    <div class="col-sm-4 ">
                        <form class="search" action="<?php print_link('arsip'); ?>" method="get">
                            <div class="input-group">
                                <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search" placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if (!empty($field_name) || !empty($_GET['search'])) {
                            ?>
                                <hr class="sm d-block d-sm-none" />
                                <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                    <ul class="breadcrumb m-0 p-1">
                                        <?php
                                        if (!empty($field_name)) {
                                        ?>
                                            <li class="breadcrumb-item">
                                                <a class="text-decoration-none" href="<?php print_link('arsip'); ?>">
                                                    <i class="fa fa-angle-left"></i>
                                                </a>
                                            </li>
                                            <li class="breadcrumb-item">
                                                <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                            </li>
                                            <li class="breadcrumb-item active text-capitalize font-weight-bold">
                                                <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                            </li>
                                        <?php
                                        }
                                        ?>
                                        <?php
                                        if (get_value("search")) {
                                        ?>
                                            <li class="breadcrumb-item">
                                                <a class="text-decoration-none" href="<?php print_link('arsip'); ?>">
                                                    <i class="fa fa-angle-left"></i>
                                                </a>
                                            </li>
                                            <li class="breadcrumb-item text-capitalize">
                                                Search
                                            </li>
                                            <li class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                        <?php
                                        }
                                        ?>
                                    </ul>
                                </nav>
                                <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }
    ?>
    <div class="">
        <div class="container-fluid">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this::display_page_errors(); ?>
                    <div class=" animated fadeIn page-content">
                        <div id="arsip-list-records">
                            <div id="page-report-body" class="table-responsive">
                                <table class="table  table-striped table-sm text-left table-bordered">
                                    <thead class="table-header bg-light">
                                        <tr>
                                            <th class="td-sno">#</th>
                                            <th class="td-nama"> Nama</th>
                                            <th class="td-nip"> NIP / NIPK</th>
                                            <th class="td-jabatan"> Jabatan</th>
                                            <th class="td-fc_sk_cpns"> Fc SK CPNS</th>
                                            <th class="td-fc_sk_pns"> Fc SK PNS</th>
                                            <th class="td-fc_sk_terakhir"> Fc SK Terakhir</th>
                                            <th class="td-fc_ijazah"> Fc Ijazah</th>
                                            <th class="td-fc_skp"> Fc SKP </th>
                                            <th class="td-fc_sertifikat"> Fc Sertifikat (Bimtek, WS, Diklat)</th>
                                            <th class="td-fc_penghargaan"> Fc Penghargaan</th>
                                            <th class="td-fc_kartu"> Fc Kartu (Pegawai, BPJS, Taspen)</th>
                                            <th class="td-fc_ktp"> Fc KTP</th>
                                            <th class="td-fc_kk"> Fc KK</th>
                                            <th class="td-fc_surat_nikah"> Fc Surat Nikah</th>
                                            <th class="td-fc_kontrak"> Fc Kontrak Kerja (Non ASN)</th>
                                            <th class="td-fc_sip"> Fc SIP</th>
                                            <th class="td-fc_str"> Fc STR</th>
                                            <th class="td-fc_sk_jabfung"> Fc SK Jabfung</th>
                                            <th class="td-fc_jenjang"> Fc Jenjang</th>
                                            <th class="td-fc_pak"> Fc PAK</th>
                                            <th class="td-upload"> Upload Dokumen</th>
                                            <th class="td-keterangan"> Keterangan</th>
                                            <th class="td-btn"></th>
                                        </tr>
                                    </thead>
                                    <?php
                                    if (!empty($records)) {
                                    ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach ($records as $data) {
                                                $rec_id = (!empty($data['id']) ? urlencode($data['id']) : null);
                                                $counter++;
                                            ?>
                                                <tr>
                                                    <th class="td-sno"><?php echo $counter; ?></th>
                                                    <td class="td-nama">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_nama_option_list'); ?>'
                                                            data-value="<?php echo $data['nama']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="nama"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['nama']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-nip">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php
                                                                                                    $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                                                                    print_link('api/json/arsip_nip_option_list/' . $dependent_field);
                                                                                                    ?>'
                                                            data-value="<?php echo $data['nip']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="nip"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['nip']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-jabatan">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php
                                                                                                    $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                                                                    print_link('api/json/arsip_jabatan_option_list/' . $dependent_field);
                                                                                                    ?>'
                                                            data-value="<?php echo $data['jabatan']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="jabatan"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['jabatan']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_sk_cpns">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_sk_cpns_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_sk_cpns']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_sk_cpns"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_sk_cpns']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_sk_pns">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_sk_pns_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_sk_pns']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_sk_pns"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_sk_pns']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_sk_terakhir">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_sk_terakhir_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_sk_terakhir']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_sk_terakhir"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_sk_terakhir']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_ijazah">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_ijazah_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_ijazah']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_ijazah"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_ijazah']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_skp">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_skp_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_skp']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_skp"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_skp']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_sertifikat">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_sertifikat_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_sertifikat']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_sertifikat"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_sertifikat']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_penghargaan">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_penghargaan_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_penghargaan']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_penghargaan"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_penghargaan']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_kartu">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_kartu_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_kartu']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_kartu"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_kartu']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_ktp">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_ktp_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_ktp']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_ktp"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_ktp']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_kk">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_kk_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_kk']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_kk"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_kk']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_surat_nikah">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_surat_nikah_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_surat_nikah']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_surat_nikah"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_surat_nikah']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_kontrak">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_kontrak_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_kontrak']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_kontrak"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_kontrak']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_sip">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_sip_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_sip']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_sip"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_sip']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_str">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_str_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_str']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_str"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_str']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_sk_jabfung">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_sk_jabfung_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_sk_jabfung']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_sk_jabfung"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_sk_jabfung']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_jenjang">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_jenjang_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_jenjang']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_jenjang"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_jenjang']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-fc_pak">
                                                        <span <?php if ($can_edit) { ?> data-source='<?php print_link('api/json/arsip_fc_pak_option_list'); ?>'
                                                            data-value="<?php echo $data['fc_pak']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="fc_pak"
                                                            data-title="Select a value ..."
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="select"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['fc_pak']; ?>
                                                        </span>
                                                    </td>
                                                    <td class="td-upload"><?php Html::page_link_file($data['upload']); ?></td>
                                                    <td class="td-keterangan">
                                                        <span <?php if ($can_edit) { ?> data-value="<?php echo $data['keterangan']; ?>"
                                                            data-pk="<?php echo $data['id'] ?>"
                                                            data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>"
                                                            data-name="keterangan"
                                                            data-title="Enter Keterangan"
                                                            data-placement="left"
                                                            data-toggle="click"
                                                            data-type="text"
                                                            data-mode="popover"
                                                            data-showbuttons="left"
                                                            class="is-editable" <?php } ?>>
                                                            <?php echo $data['keterangan']; ?>
                                                        </span>
                                                    </td>
                                                    <th class="td-btn">
                                                        <?php if ($can_view) { ?>
                                                            <a class="btn btn-sm btn-success has-tooltip" title="View Record" href="<?php print_link("arsip/view/$rec_id"); ?>">
                                                                <i class="fa fa-eye"></i> View
                                                            </a>
                                                        <?php } ?>
                                                        <?php if ($can_edit) { ?>
                                                            <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("arsip/edit/$rec_id"); ?>">
                                                                <i class="fa fa-edit"></i> Edit
                                                            </a>
                                                        <?php } ?>
                                                        <?php if ($can_delete) { ?>
                                                            <a class="btn btn-sm btn-danger has-tooltip record-delete-btn" title="Delete this record" href="<?php print_link("arsip/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                                <i class="fa fa-times"></i>
                                                                Delete
                                                            </a>
                                                        <?php } ?>
                                                    </th>
                                                </tr>
                                            <?php
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                    <?php
                                    }
                                    ?>
                                </table>
                                <?php
                                if (empty($records)) {
                                ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="fa fa-ban"></i> No record found
                                    </h4>
                                <?php
                                }
                                ?>
                            </div>
                            <?php
                            if ($show_footer && !empty($records)) {
                            ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">
                                        <div class="col-md-auto justify-content-center">
                                            <div class="p-3 d-flex justify-content-between">
                                                <?php if ($can_delete) { ?>
                                                    <button data-prompt-msg="Are you sure you want to delete these records?" data-display-style="modal" data-url="<?php print_link("arsip/delete/{sel_ids}/?csrf_token=$csrf_token&redirect=$current_page"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                        <i class="fa fa-times"></i> Delete Selected
                                                    </button>
                                                <?php } ?>
                                                <div class="dropup export-btn-holder mx-1">
                                                    <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        <i class="fa fa-save"></i> Export
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                        <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                                        </a>
                                                        <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                                        </a>
                                                        <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                        </a>
                                                        <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                        </a>
                                                        <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <?php
                                            if ($show_pagination == true) {
                                                $pager = new Pagination($total_records, $record_count);
                                                $pager->route = $this->route;
                                                $pager->show_page_count = true;
                                                $pager->show_record_count = true;
                                                $pager->show_page_limit = true;
                                                $pager->limit_count = $this->limit_count;
                                                $pager->show_page_number_list = true;
                                                $pager->pager_link_range = 5;
                                                $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>