<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("arsip/add");
$can_edit = ACL::is_allowed("arsip/edit");
$can_view = ACL::is_allowed("arsip/view");
$can_delete = ACL::is_allowed("arsip/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "view-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data Information from Controller
$data = $this->view_data;
//$rec_id = $data['__tableprimarykey'];
$page_id = $this->route->page_id; //Page id from url
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_edit_btn = $this->show_edit_btn;
$show_delete_btn = $this->show_delete_btn;
$show_export_btn = $this->show_export_btn;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="view"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">View Dokumen Pegawai</h4>
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class="card animated fadeIn page-content">
                        <?php
                        $counter = 0;
                        if(!empty($data)){
                        $rec_id = (!empty($data['id']) ? urlencode($data['id']) : null);
                        $counter++;
                        ?>
                        <div id="page-report-body" class="">
                            <table class="table table-hover table-borderless table-striped">
                                <!-- Table Body Start -->
                                <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                    <tr  class="td-nama">
                                        <th class="title"> Nama: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_nama_option_list'); ?>' 
                                                data-value="<?php echo $data['nama']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="nama" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nama']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-nip">
                                        <th class="title"> NIP / NIPK: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php 
                                                $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                print_link('api/json/arsip_nip_option_list/'.$dependent_field); 
                                                ?>' 
                                                data-value="<?php echo $data['nip']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="nip" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nip']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-jabatan">
                                        <th class="title"> Jabatan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php 
                                                $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                print_link('api/json/arsip_jabatan_option_list/'.$dependent_field); 
                                                ?>' 
                                                data-value="<?php echo $data['jabatan']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="jabatan" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['jabatan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_sk_cpns">
                                        <th class="title"> Fc SK CPNS: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_sk_cpns_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_sk_cpns']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_sk_cpns" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_sk_cpns']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_sk_pns">
                                        <th class="title"> Fc SK PNS: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_sk_pns_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_sk_pns']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_sk_pns" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_sk_pns']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_sk_terakhir">
                                        <th class="title"> Fc SK Terakhir: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_sk_terakhir_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_sk_terakhir']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_sk_terakhir" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_sk_terakhir']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_ijazah">
                                        <th class="title"> Fc Ijazah: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_ijazah_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_ijazah']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_ijazah" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_ijazah']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_skp">
                                        <th class="title"> Fc SKP: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_skp_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_skp']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_skp" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_skp']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_sertifikat">
                                        <th class="title"> Fc Sertifikat (Bimtek, WS, Diklat): </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_sertifikat_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_sertifikat']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_sertifikat" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_sertifikat']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_penghargaan">
                                        <th class="title"> Fc Penghargaan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_penghargaan_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_penghargaan']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_penghargaan" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_penghargaan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_kartu">
                                        <th class="title"> Fc Kartu (Pegawai, BPJS, Taspen): </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_kartu_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_kartu']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_kartu" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_kartu']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_ktp">
                                        <th class="title"> Fc KTP: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_ktp_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_ktp']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_ktp" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_ktp']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_kk">
                                        <th class="title"> Fc KK: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_kk_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_kk']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_kk" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_kk']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_surat_nikah">
                                        <th class="title"> Fc Surat Nikah: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_surat_nikah_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_surat_nikah']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_surat_nikah" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_surat_nikah']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_kontrak">
                                        <th class="title"> Fc Kontrak Kerja (Non ASN): </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_kontrak_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_kontrak']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_kontrak" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_kontrak']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_sip">
                                        <th class="title"> Fc Sip: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_sip_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_sip']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_sip" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_sip']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_str">
                                        <th class="title"> Fc Str: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_str_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_str']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_str" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_str']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_sk_jabfung">
                                        <th class="title"> Fc Sk Jabfung: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_sk_jabfung_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_sk_jabfung']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_sk_jabfung" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_sk_jabfung']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_jenjang">
                                        <th class="title"> Fc Jenjang: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_jenjang_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_jenjang']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_jenjang" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_jenjang']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-fc_pak">
                                        <th class="title"> Fc Pak: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/arsip_fc_pak_option_list'); ?>' 
                                                data-value="<?php echo $data['fc_pak']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="fc_pak" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['fc_pak']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-upload">
                                        <th class="title"> Upload Dokumen: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['upload']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="upload" 
                                                data-title="Enter Upload Dokumen" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['upload']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-keterangan">
                                        <th class="title"> Keterangan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['keterangan']; ?>" 
                                                data-pk="<?php echo $data['id'] ?>" 
                                                data-url="<?php print_link("arsip/editfield/" . urlencode($data['id'])); ?>" 
                                                data-name="keterangan" 
                                                data-title="Enter Keterangan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['keterangan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                                <!-- Table Body End -->
                            </table>
                        </div>
                        <div class="p-3 d-flex">
                            <div class="dropup export-btn-holder mx-1">
                                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-save"></i> Export
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                    <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                        <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                        </a>
                                        <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                        <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                            <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                            </a>
                                            <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                            <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                </a>
                                                <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                    <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                    </a>
                                                    <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                    <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                        <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                        </a>
                                                    </div>
                                                </div>
                                                <?php if($can_edit){ ?>
                                                <a class="btn btn-sm btn-info"  href="<?php print_link("arsip/edit/$rec_id"); ?>">
                                                    <i class="fa fa-edit"></i> Edit
                                                </a>
                                                <?php } ?>
                                                <?php if($can_delete){ ?>
                                                <a class="btn btn-sm btn-danger record-delete-btn mx-1"  href="<?php print_link("arsip/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                    <i class="fa fa-times"></i> Delete
                                                </a>
                                                <?php } ?>
                                            </div>
                                            <?php
                                            }
                                            else{
                                            ?>
                                            <!-- Empty Record Message -->
                                            <div class="text-muted p-3">
                                                <i class="fa fa-ban"></i> No Record Found
                                            </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
