<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("aset_lancar/add");
$can_edit = ACL::is_allowed("aset_lancar/edit");
$can_view = ACL::is_allowed("aset_lancar/view");
$can_delete = ACL::is_allowed("aset_lancar/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "view-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data Information from Controller
$data = $this->view_data;
//$rec_id = $data['__tableprimarykey'];
$page_id = $this->route->page_id; //Page id from url
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_edit_btn = $this->show_edit_btn;
$show_delete_btn = $this->show_delete_btn;
$show_export_btn = $this->show_export_btn;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="view"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">View Aset Lancar</h4>
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class="card animated fadeIn page-content">
                        <?php
                        $counter = 0;
                        if(!empty($data)){
                        $rec_id = (!empty($data['id_aset_lancar']) ? urlencode($data['id_aset_lancar']) : null);
                        $counter++;
                        ?>
                        <div id="page-report-body" class="">
                            <table class="table table-hover table-borderless table-striped">
                                <!-- Table Body Start -->
                                <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                    <tr  class="td-id_aset_lancar">
                                        <th class="title"> Id Aset Lancar: </th>
                                        <td class="value"> <?php echo $data['id_aset_lancar']; ?></td>
                                    </tr>
                                    <tr  class="td-sumber_anggaran">
                                        <th class="title"> Sumber Anggaran: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/aset_lancar_sumber_anggaran_option_list'); ?>' 
                                                data-value="<?php echo $data['sumber_anggaran']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="sumber_anggaran" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['sumber_anggaran']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-uraian">
                                        <th class="title"> Uraian Belanja: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/aset_lancar_uraian_option_list'); ?>' 
                                                data-value="<?php echo $data['uraian']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="uraian" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['uraian']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-nama_barang">
                                        <th class="title"> Nama Barang: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/aset_lancar_nama_barang_option_list'); ?>' 
                                                data-value="<?php echo $data['nama_barang']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="nama_barang" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nama_barang']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-kode_barang">
                                        <th class="title"> Kode Barang: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php 
                                                $dependent_field = (!empty($data['nama_barang']) ? urlencode($data['nama_barang']) : null);
                                                print_link('api/json/aset_lancar_kode_barang_option_list/'.$dependent_field); 
                                                ?>' 
                                                data-value="<?php echo $data['kode_barang']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="kode_barang" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['kode_barang']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tgl_terima">
                                        <th class="title"> Tgl Terima: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_terima']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="tgl_terima" 
                                                data-title="Enter Tgl. Terima" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_terima']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-penerimaan">
                                        <th class="title"> Jumlah Barang: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['penerimaan']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="penerimaan" 
                                                data-title="Enter Jumlah Barang" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['penerimaan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-satuan">
                                        <th class="title"> Satuan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/aset_lancar_satuan_option_list'); ?>' 
                                                data-value="<?php echo $data['satuan']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="satuan" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['satuan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tgl_keluar">
                                        <th class="title"> Tgl Keluar: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_keluar']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="tgl_keluar" 
                                                data-title="Enter Tgl. Keluar" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_keluar']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-pengeluaran">
                                        <th class="title"> Pengeluaran: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['pengeluaran']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="pengeluaran" 
                                                data-title="Enter Pengeluaran" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['pengeluaran']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-keterangan">
                                        <th class="title"> Keterangan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['keterangan']; ?>" 
                                                data-pk="<?php echo $data['id_aset_lancar'] ?>" 
                                                data-url="<?php print_link("aset_lancar/editfield/" . urlencode($data['id_aset_lancar'])); ?>" 
                                                data-name="keterangan" 
                                                data-title="Enter Keterangan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['keterangan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                                <!-- Table Body End -->
                            </table>
                        </div>
                        <div class="p-3 d-flex">
                            <div class="dropup export-btn-holder mx-1">
                                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-save"></i> Export
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                    <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                        <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                        </a>
                                        <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                        <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                            <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                            </a>
                                            <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                            <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                </a>
                                                <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                    <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                    </a>
                                                    <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                    <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                        <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                        </a>
                                                    </div>
                                                </div>
                                                <?php if($can_edit){ ?>
                                                <a class="btn btn-sm btn-info"  href="<?php print_link("aset_lancar/edit/$rec_id"); ?>">
                                                    <i class="fa fa-edit"></i> Edit
                                                </a>
                                                <?php } ?>
                                                <?php if($can_delete){ ?>
                                                <a class="btn btn-sm btn-danger record-delete-btn mx-1"  href="<?php print_link("aset_lancar/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                    <i class="fa fa-times"></i> Delete
                                                </a>
                                                <?php } ?>
                                            </div>
                                            <?php
                                            }
                                            else{
                                            ?>
                                            <!-- Empty Record Message -->
                                            <div class="text-muted p-3">
                                                <i class="fa fa-ban"></i> No Record Found
                                            </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
