<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("aset_tetap/add");
$can_edit = ACL::is_allowed("aset_tetap/edit");
$can_view = ACL::is_allowed("aset_tetap/view");
$can_delete = ACL::is_allowed("aset_tetap/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "view-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data Information from Controller
$data = $this->view_data;
//$rec_id = $data['__tableprimarykey'];
$page_id = $this->route->page_id; //Page id from url
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_edit_btn = $this->show_edit_btn;
$show_delete_btn = $this->show_delete_btn;
$show_export_btn = $this->show_export_btn;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="view"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">View  Aset Tetap</h4>
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class="card animated fadeIn page-content">
                        <?php
                        $counter = 0;
                        if(!empty($data)){
                        $rec_id = (!empty($data['id_aset_tetap']) ? urlencode($data['id_aset_tetap']) : null);
                        $counter++;
                        ?>
                        <div id="page-report-body" class="">
                            <table class="table table-hover table-borderless table-striped">
                                <!-- Table Body Start -->
                                <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                    <tr  class="td-tgl_beli">
                                        <th class="title"> Tgl. Pembelian: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_beli']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="tgl_beli" 
                                                data-title="Enter Tgl. Pembelian" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_beli']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-uraian">
                                        <th class="title"> Uraian: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/aset_tetap_uraian_option_list'); ?>' 
                                                data-value="<?php echo $data['uraian']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="uraian" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['uraian']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-nama">
                                        <th class="title"> Nama Barang: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/aset_tetap_nama_option_list'); ?>' 
                                                data-value="<?php echo $data['nama']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="nama" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nama']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-kode">
                                        <th class="title"> Kode Barang: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php 
                                                $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                print_link('api/json/aset_tetap_kode_option_list/'.$dependent_field); 
                                                ?>' 
                                                data-value="<?php echo $data['kode']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="kode" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['kode']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-jenis">
                                        <th class="title"> Jenis Belanja: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/aset_tetap_jenis_option_list'); ?>' 
                                                data-value="<?php echo $data['jenis']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="jenis" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['jenis']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-spesifikasi">
                                        <th class="title"> Spesifikasi: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="spesifikasi" 
                                                data-title="Enter Spesifikasi" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="textarea" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['spesifikasi']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-jumlah">
                                        <th class="title"> Total Barang: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['jumlah']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="jumlah" 
                                                data-title="Enter Total Barang" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['jumlah']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-satuan">
                                        <th class="title"> Satuan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/aset_tetap_satuan_option_list'); ?>' 
                                                data-value="<?php echo $data['satuan']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="satuan" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['satuan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-kondisi_baik">
                                        <th class="title"> Jumlah Barang Baik: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['kondisi_baik']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="kondisi_baik" 
                                                data-title="Enter Jumlah Barang Baik" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['kondisi_baik']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-kondisi_rusak">
                                        <th class="title"> Jumlah Barang Rusak: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['kondisi_rusak']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="kondisi_rusak" 
                                                data-title="Enter Jumlah Barang Rusak" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['kondisi_rusak']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-kondisi_ringan">
                                        <th class="title"> Jumlah Barang Rusak Ringan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['kondisi_ringan']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="kondisi_ringan" 
                                                data-title="Enter Jumlah Barang Rusak Ringan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['kondisi_ringan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-keterangan">
                                        <th class="title"> Keterangan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['keterangan']; ?>" 
                                                data-pk="<?php echo $data['id_aset_tetap'] ?>" 
                                                data-url="<?php print_link("aset_tetap/editfield/" . urlencode($data['id_aset_tetap'])); ?>" 
                                                data-name="keterangan" 
                                                data-title="Enter Keterangan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['keterangan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                                <!-- Table Body End -->
                            </table>
                        </div>
                        <div class="p-3 d-flex">
                            <div class="dropup export-btn-holder mx-1">
                                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-save"></i> Export
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                    <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                        <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                        </a>
                                        <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                        <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                            <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                            </a>
                                            <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                            <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                </a>
                                                <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                    <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                    </a>
                                                    <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                    <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                        <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                        </a>
                                                    </div>
                                                </div>
                                                <?php if($can_edit){ ?>
                                                <a class="btn btn-sm btn-info"  href="<?php print_link("aset_tetap/edit/$rec_id"); ?>">
                                                    <i class="fa fa-edit"></i> Edit
                                                </a>
                                                <?php } ?>
                                                <?php if($can_delete){ ?>
                                                <a class="btn btn-sm btn-danger record-delete-btn mx-1"  href="<?php print_link("aset_tetap/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                    <i class="fa fa-times"></i> Delete
                                                </a>
                                                <?php } ?>
                                            </div>
                                            <?php
                                            }
                                            else{
                                            ?>
                                            <!-- Empty Record Message -->
                                            <div class="text-muted p-3">
                                                <i class="fa fa-ban"></i> No Record Found
                                            </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
