<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("bln_april/add");
$can_edit = ACL::is_allowed("bln_april/edit");
$can_view = ACL::is_allowed("bln_april/view");
$can_delete = ACL::is_allowed("bln_april/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Jadwal Bulan April</h4>
                </div>
                <div class="col-sm-3 ">
                    <?php if($can_add){ ?>
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("bln_april/add") ?>">
                        <i class="fa fa-plus"></i>                              
                        Tambah Pegawai 
                    </a>
                    <?php } ?>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('bln_april'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('bln_april'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('bln_april'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="bln_april-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <table class="table  table-striped table-sm text-left table-bordered">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-sno">#</th>
                                                <th  class="td-nama"> Nama</th>
                                                <th  class="td-nip"> NIP / NIPK</th>
                                                <th  class="td-tgl_1"> Tgl 1</th>
                                                <th  class="td-tgl_2"> Tgl 2</th>
                                                <th  class="td-tgl_3"> Tgl 3</th>
                                                <th  class="td-tgl_4"> Tgl 4</th>
                                                <th  class="td-tgl_5"> Tgl 5</th>
                                                <th  class="td-tgl_6"> Tgl 6</th>
                                                <th  class="td-tgl_7"> Tgl 7</th>
                                                <th  class="td-tgl_8"> Tgl 8</th>
                                                <th  class="td-tgl_9"> Tgl 9</th>
                                                <th  class="td-tgl_10"> Tgl 10</th>
                                                <th  class="td-tgl_11"> Tgl 11</th>
                                                <th  class="td-tgl_12"> Tgl 12</th>
                                                <th  class="td-tgl_13"> Tgl 13</th>
                                                <th  class="td-tgl_14"> Tgl 14</th>
                                                <th  class="td-tgl_15"> Tgl 15</th>
                                                <th  class="td-tgl_16"> Tgl 16</th>
                                                <th  class="td-tgl_17"> Tgl 17</th>
                                                <th  class="td-tgl_18"> Tgl 18</th>
                                                <th  class="td-tgl_19"> Tgl 19</th>
                                                <th  class="td-tgl_20"> Tgl 20</th>
                                                <th  class="td-tgl_21"> Tgl 21</th>
                                                <th  class="td-tgl_22"> Tgl 22</th>
                                                <th  class="td-tgl_23"> Tgl 23</th>
                                                <th  class="td-tgl_24"> Tgl 24</th>
                                                <th  class="td-tgl_25"> Tgl 25</th>
                                                <th  class="td-tgl_26"> Tgl 26</th>
                                                <th  class="td-tgl_27"> Tgl 27</th>
                                                <th  class="td-tgl_28"> Tgl 28</th>
                                                <th  class="td-tgl_29"> Tgl 29</th>
                                                <th  class="td-tgl_30"> Tgl 30</th>
                                                <th  class="td-tgl_31"> Tgl 31</th>
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['id']) ? urlencode($data['id']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-sno"><?php echo $counter; ?></th>
                                                <td class="td-nama">
                                                    <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/bln_april_nama_option_list'); ?>' 
                                                        data-value="<?php echo $data['nama']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="nama" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['nama']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-nip">
                                                    <span <?php if($can_edit){ ?> data-source='<?php 
                                                        $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                        print_link('api/json/bln_april_nip_option_list/'.$dependent_field); 
                                                        ?>' 
                                                        data-value="<?php echo $data['nip']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="nip" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['nip']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_1">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_1']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_1" 
                                                        data-title="Enter Tgl 1" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_1']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_2">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_2']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_2" 
                                                        data-title="Enter Tgl 2" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_2']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_3">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_3']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_3" 
                                                        data-title="Enter Tgl 3" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_3']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_4">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_4']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_4" 
                                                        data-title="Enter Tgl 4" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_4']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_5">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_5']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_5" 
                                                        data-title="Enter Tgl 5" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_5']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_6">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_6']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_6" 
                                                        data-title="Enter Tgl 6" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_6']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_7">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_7']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_7" 
                                                        data-title="Enter Tgl 7" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_7']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_8">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_8']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_8" 
                                                        data-title="Enter Tgl 8" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_8']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_9">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_9']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_9" 
                                                        data-title="Enter Tgl 9" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_9']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_10">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_10']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_10" 
                                                        data-title="Enter Tgl 10" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_10']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_11">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_11']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_11" 
                                                        data-title="Enter Tgl 11" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_11']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_12">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_12']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_12" 
                                                        data-title="Enter Tgl 12" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_12']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_13">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_13']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_13" 
                                                        data-title="Enter Tgl 13" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_13']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_14">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_14']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_14" 
                                                        data-title="Enter Tgl 14" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_14']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_15">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_15']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_15" 
                                                        data-title="Enter Tgl 15" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_15']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_16">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_16']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_16" 
                                                        data-title="Enter Tgl 16" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_16']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_17">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_17']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_17" 
                                                        data-title="Enter Tgl 17" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_17']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_18">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_18']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_18" 
                                                        data-title="Enter Tgl 18" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_18']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_19">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_19']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_19" 
                                                        data-title="Enter Tgl 19" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_19']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_20">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_20']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_20" 
                                                        data-title="Enter Tgl 20" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_20']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_21">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_21']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_21" 
                                                        data-title="Enter Tgl 21" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_21']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_22">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_22']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_22" 
                                                        data-title="Enter Tgl 22" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_22']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_23">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_23']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_23" 
                                                        data-title="Enter Tgl 23" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_23']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_24">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_24']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_24" 
                                                        data-title="Enter Tgl 24" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_24']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_25">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_25']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_25" 
                                                        data-title="Enter Tgl 25" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_25']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_26">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_26']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_26" 
                                                        data-title="Enter Tgl 26" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_26']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_27">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_27']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_27" 
                                                        data-title="Enter Tgl 27" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_27']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_28">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_28']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_28" 
                                                        data-title="Enter Tgl 28" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_28']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_29">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_29']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_29" 
                                                        data-title="Enter Tgl 29" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_29']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_30">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_30']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_30" 
                                                        data-title="Enter Tgl 30" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_30']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_31">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl_31']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bln_april/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl_31" 
                                                        data-title="Enter Tgl 31" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_31']; ?> 
                                                    </span>
                                                </td>
                                                <th class="td-btn">
                                                    <?php if($can_edit){ ?>
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("bln_april/edit/$rec_id"); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <?php } ?>
                                                    <?php if($can_delete){ ?>
                                                    <a class="btn btn-sm btn-danger has-tooltip record-delete-btn" title="Delete this record" href="<?php print_link("bln_april/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                        <i class="fa fa-times"></i>
                                                        Delete
                                                    </a>
                                                    <?php } ?>
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="fa fa-ban"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                                <?php if($can_delete){ ?>
                                                <button data-prompt-msg="Are you sure you want to delete these records?" data-display-style="modal" data-url="<?php print_link("bln_april/delete/{sel_ids}/?csrf_token=$csrf_token&redirect=$current_page"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                    <i class="fa fa-times"></i> Delete Selected
                                                </button>
                                                <?php } ?>
                                                <div class="dropup export-btn-holder mx-1">
                                                    <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        <i class="fa fa-save"></i> Export
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                        <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                                            </a>
                                                            <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                                            <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                                                <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                                                </a>
                                                                <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                                                <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                                    <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                                    </a>
                                                                    <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                                    <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                                        <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                                        </a>
                                                                        <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                                        <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                                            <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col">   
                                                                <?php
                                                                if($show_pagination == true){
                                                                $pager = new Pagination($total_records, $record_count);
                                                                $pager->route = $this->route;
                                                                $pager->show_page_count = true;
                                                                $pager->show_record_count = true;
                                                                $pager->show_page_limit =true;
                                                                $pager->limit_count = $this->limit_count;
                                                                $pager->show_page_number_list = true;
                                                                $pager->pager_link_range=5;
                                                                $pager->render();
                                                                }
                                                                ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
