<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Absensi Bulan Januari</h4>
                </div>
                <div class="col-sm-3 ">
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("bulan_januari/add") ?>">
                        <i class="fa fa-plus"></i>                              
                        Tambah Pegawai 
                    </a>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('bulan_januari'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('bulan_januari'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('bulan_januari'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="bulan_januari-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <table class="table  table-striped table-sm text-left table-bordered">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-sno">#</th>
                                                <th  class="td-nama"> Nama Pegawai</th>
                                                <th  class="td-nip"> NIP / NIPK</th>
                                                <th  class="td-tgl1_P"> Tgl.1 Pagi</th>
                                                <th  class="td-tgl1_S"> Tgl.1 Sore</th>
                                                <th  class="td-tgl2_P"> Tgl.2 Pagi</th>
                                                <th  class="td-tgl2_S"> Tgl.2 Sore</th>
                                                <th  class="td-tgl3_P"> Tgl.3 Pagi</th>
                                                <th  class="td-tgl3_S"> Tgl.3 Sore</th>
                                                <th  class="td-tgl4_P"> Tgl.4 Pagi</th>
                                                <th  class="td-tgl4_S"> Tgl.4 Sore</th>
                                                <th  class="td-tgl5_P"> Tgl.5 Pagi</th>
                                                <th  class="td-tgl5_S"> Tgl.5 Sore</th>
                                                <th  class="td-tgl6_P"> Tgl.6 Pagi</th>
                                                <th  class="td-tgl6_S"> Tgl.6 Sore</th>
                                                <th  class="td-tgl7_P"> Tgl.7 Pagi</th>
                                                <th  class="td-tgl7_S"> Tgl.7 Sore</th>
                                                <th  class="td-tgl8_P"> Tgl.8 Pagi</th>
                                                <th  class="td-tgl8_S"> Tgl.8 Sore</th>
                                                <th  class="td-tgl9_P"> Tgl.9 Pagi</th>
                                                <th  class="td-tgl9_S"> Tgl.9 Sore</th>
                                                <th  class="td-tgl10_P"> Tgl.10 Pagi</th>
                                                <th  class="td-tgl10_S"> Tgl.10 Sore</th>
                                                <th  class="td-tgl11_P"> Tgl.11 Pagi</th>
                                                <th  class="td-tgl11_S"> Tgl.11 Sore</th>
                                                <th  class="td-tgl12_P"> Tgl.12 Pagi</th>
                                                <th  class="td-tgl12_S"> Tgl.12 Sore</th>
                                                <th  class="td-tgl13_P"> Tgl.13 Pagi</th>
                                                <th  class="td-tgl13_S"> Tgl.13 Sore</th>
                                                <th  class="td-tgl14_P"> Tgl.14 Pagi</th>
                                                <th  class="td-tgl14_S"> Tgl.14 Sore</th>
                                                <th  class="td-tgl15_P"> Tgl.15 Pagi</th>
                                                <th  class="td-tgl15_S"> Tgl.15 Sore</th>
                                                <th  class="td-tgl16_P"> Tgl.16 Pagi</th>
                                                <th  class="td-tgl16_S"> Tgl.16 Sore</th>
                                                <th  class="td-tgl17_P"> Tgl.17 Pagi</th>
                                                <th  class="td-tgl17_S"> Tgl.17 Sore</th>
                                                <th  class="td-tgl18_P"> Tgl.18 Pagi</th>
                                                <th  class="td-tgl18_S"> Tgl.18 Sore</th>
                                                <th  class="td-tgl19_P"> Tgl.19 Pagi</th>
                                                <th  class="td-tgl19_S"> Tgl.19 Sore</th>
                                                <th  class="td-tgl20_P"> Tgl.20 Pagi</th>
                                                <th  class="td-tgl20_S"> Tgl.20 Sore</th>
                                                <th  class="td-tgl21_P"> Tgl.21 Pagi</th>
                                                <th  class="td-tgl21_S"> Tgl.21 Sore</th>
                                                <th  class="td-tgl22_P"> Tgl.22 Pagi</th>
                                                <th  class="td-tgl22_S"> Tgl.22 Sore</th>
                                                <th  class="td-tgl23_P"> Tgl.23 Pagi</th>
                                                <th  class="td-tgl23_S"> Tgl.23 Sore</th>
                                                <th  class="td-tgl24_P"> Tgl.24 Pagi</th>
                                                <th  class="td-tgl24_S"> Tgl.24 Sore</th>
                                                <th  class="td-tgl25_P"> Tgl.25 Pagi</th>
                                                <th  class="td-tgl25_S"> Tgl.25 Sore</th>
                                                <th  class="td-tgl26_P"> Tgl.26 Pagi</th>
                                                <th  class="td-tgl26_S"> Tgl.26 Sore</th>
                                                <th  class="td-tgl27_P"> Tgl.27 Pagi</th>
                                                <th  class="td-tgl27_S"> Tgl.27 Sore</th>
                                                <th  class="td-tgl28_P"> Tgl.28 Pagi</th>
                                                <th  class="td-tgl28_S"> Tgl.28 Sore</th>
                                                <th  class="td-tgl29_P"> Tgl.29 Pagi</th>
                                                <th  class="td-tgl29_S"> Tgl.29 Sore</th>
                                                <th  class="td-tgl30_P"> Tgl.30 Pagi</th>
                                                <th  class="td-tgl30_S"> Tgl.30 Sore</th>
                                                <th  class="td-tgl31_P"> Tgl.31 Pagi</th>
                                                <th  class="td-tgl31_S"> Tgl.31 Sore</th>
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['id']) ? urlencode($data['id']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-sno"><?php echo $counter; ?></th>
                                                <td class="td-nama"> <?php echo $data['nama']; ?></td>
                                                <td class="td-nip"> <?php echo $data['nip']; ?></td>
                                                <td class="td-tgl1_P">
                                                    <span  data-value="<?php echo $data['tgl1_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl1_P" 
                                                        data-title="Enter Tgl.1 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl1_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl1_S">
                                                    <span  data-value="<?php echo $data['tgl1_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl1_S" 
                                                        data-title="Enter Tgl.1 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl1_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl2_P">
                                                    <span  data-value="<?php echo $data['tgl2_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl2_P" 
                                                        data-title="Enter Tgl.2 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl2_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl2_S">
                                                    <span  data-value="<?php echo $data['tgl2_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl2_S" 
                                                        data-title="Enter Tgl.2 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl2_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl3_P">
                                                    <span  data-value="<?php echo $data['tgl3_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl3_P" 
                                                        data-title="Enter Tgl.3 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl3_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl3_S">
                                                    <span  data-value="<?php echo $data['tgl3_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl3_S" 
                                                        data-title="Enter Tgl.3 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl3_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl4_P">
                                                    <span  data-value="<?php echo $data['tgl4_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl4_P" 
                                                        data-title="Enter Tgl.4 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl4_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl4_S">
                                                    <span  data-value="<?php echo $data['tgl4_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl4_S" 
                                                        data-title="Enter Tgl.4 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl4_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl5_P">
                                                    <span  data-value="<?php echo $data['tgl5_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl5_P" 
                                                        data-title="Enter Tgl.5 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl5_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl5_S">
                                                    <span  data-value="<?php echo $data['tgl5_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl5_S" 
                                                        data-title="Enter Tgl.5 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl5_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl6_P">
                                                    <span  data-value="<?php echo $data['tgl6_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl6_P" 
                                                        data-title="Enter Tgl.6 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl6_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl6_S">
                                                    <span  data-value="<?php echo $data['tgl6_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl6_S" 
                                                        data-title="Enter Tgl.6 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl6_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl7_P">
                                                    <span  data-value="<?php echo $data['tgl7_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl7_P" 
                                                        data-title="Enter Tgl.7 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl7_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl7_S">
                                                    <span  data-value="<?php echo $data['tgl7_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl7_S" 
                                                        data-title="Enter Tgl.7 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl7_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl8_P">
                                                    <span  data-value="<?php echo $data['tgl8_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl8_P" 
                                                        data-title="Enter Tgl.8 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl8_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl8_S">
                                                    <span  data-value="<?php echo $data['tgl8_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl8_S" 
                                                        data-title="Enter Tgl.8 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl8_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl9_P">
                                                    <span  data-value="<?php echo $data['tgl9_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl9_P" 
                                                        data-title="Enter Tgl.9 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl9_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl9_S">
                                                    <span  data-value="<?php echo $data['tgl9_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl9_S" 
                                                        data-title="Enter Tgl.9 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl9_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl10_P">
                                                    <span  data-value="<?php echo $data['tgl10_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl10_P" 
                                                        data-title="Enter Tgl.10 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl10_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl10_S">
                                                    <span  data-value="<?php echo $data['tgl10_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl10_S" 
                                                        data-title="Enter Tgl.10 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl10_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl11_P">
                                                    <span  data-value="<?php echo $data['tgl11_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl11_P" 
                                                        data-title="Enter Tgl.11 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl11_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl11_S">
                                                    <span  data-value="<?php echo $data['tgl11_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl11_S" 
                                                        data-title="Enter Tgl.11 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl11_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl12_P">
                                                    <span  data-value="<?php echo $data['tgl12_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl12_P" 
                                                        data-title="Enter Tgl.12 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl12_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl12_S">
                                                    <span  data-value="<?php echo $data['tgl12_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl12_S" 
                                                        data-title="Enter Tgl.12 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl12_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl13_P">
                                                    <span  data-value="<?php echo $data['tgl13_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl13_P" 
                                                        data-title="Enter Tgl.13 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl13_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl13_S">
                                                    <span  data-value="<?php echo $data['tgl13_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl13_S" 
                                                        data-title="Enter Tgl.13 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl13_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl14_P">
                                                    <span  data-value="<?php echo $data['tgl14_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl14_P" 
                                                        data-title="Enter Tgl.14 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl14_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl14_S">
                                                    <span  data-value="<?php echo $data['tgl14_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl14_S" 
                                                        data-title="Enter Tgl.14 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl14_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl15_P">
                                                    <span  data-value="<?php echo $data['tgl15_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl15_P" 
                                                        data-title="Enter Tgl.15 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl15_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl15_S">
                                                    <span  data-value="<?php echo $data['tgl15_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl15_S" 
                                                        data-title="Enter Tgl.15 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl15_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl16_P">
                                                    <span  data-value="<?php echo $data['tgl16_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl16_P" 
                                                        data-title="Enter Tgl.16 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl16_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl16_S">
                                                    <span  data-value="<?php echo $data['tgl16_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl16_S" 
                                                        data-title="Enter Tgl.16 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl16_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl17_P">
                                                    <span  data-value="<?php echo $data['tgl17_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl17_P" 
                                                        data-title="Enter Tgl.17 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl17_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl17_S">
                                                    <span  data-value="<?php echo $data['tgl17_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl17_S" 
                                                        data-title="Enter Tgl.17 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl17_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl18_P">
                                                    <span  data-value="<?php echo $data['tgl18_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl18_P" 
                                                        data-title="Enter Tgl.18 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl18_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl18_S">
                                                    <span  data-value="<?php echo $data['tgl18_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl18_S" 
                                                        data-title="Enter Tgl.18 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl18_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl19_P">
                                                    <span  data-value="<?php echo $data['tgl19_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl19_P" 
                                                        data-title="Enter Tgl.19 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl19_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl19_S">
                                                    <span  data-value="<?php echo $data['tgl19_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl19_S" 
                                                        data-title="Enter Tgl.19 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl19_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl20_P">
                                                    <span  data-value="<?php echo $data['tgl20_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl20_P" 
                                                        data-title="Enter Tgl.20 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl20_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl20_S">
                                                    <span  data-value="<?php echo $data['tgl20_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl20_S" 
                                                        data-title="Enter Tgl.20 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl20_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl21_P">
                                                    <span  data-value="<?php echo $data['tgl21_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl21_P" 
                                                        data-title="Enter Tgl.21 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl21_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl21_S">
                                                    <span  data-value="<?php echo $data['tgl21_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl21_S" 
                                                        data-title="Enter Tgl.21 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl21_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl22_P">
                                                    <span  data-value="<?php echo $data['tgl22_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl22_P" 
                                                        data-title="Enter Tgl.22 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl22_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl22_S">
                                                    <span  data-value="<?php echo $data['tgl22_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl22_S" 
                                                        data-title="Enter Tgl.22 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl22_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl23_P">
                                                    <span  data-value="<?php echo $data['tgl23_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl23_P" 
                                                        data-title="Enter Tgl.23 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl23_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl23_S">
                                                    <span  data-value="<?php echo $data['tgl23_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl23_S" 
                                                        data-title="Enter Tgl.23 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl23_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl24_P">
                                                    <span  data-value="<?php echo $data['tgl24_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl24_P" 
                                                        data-title="Enter Tgl.24 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl24_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl24_S">
                                                    <span  data-value="<?php echo $data['tgl24_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl24_S" 
                                                        data-title="Enter Tgl.24 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl24_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl25_P">
                                                    <span  data-value="<?php echo $data['tgl25_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl25_P" 
                                                        data-title="Enter Tgl.25 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl25_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl25_S">
                                                    <span  data-value="<?php echo $data['tgl25_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl25_S" 
                                                        data-title="Enter Tgl.25 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl25_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl26_P">
                                                    <span  data-value="<?php echo $data['tgl26_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl26_P" 
                                                        data-title="Enter Tgl.26 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl26_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl26_S">
                                                    <span  data-value="<?php echo $data['tgl26_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl26_S" 
                                                        data-title="Enter Tgl.26 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl26_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl27_P">
                                                    <span  data-value="<?php echo $data['tgl27_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl27_P" 
                                                        data-title="Enter Tgl.27 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl27_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl27_S">
                                                    <span  data-value="<?php echo $data['tgl27_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl27_S" 
                                                        data-title="Enter Tgl.27 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl27_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl28_P">
                                                    <span  data-value="<?php echo $data['tgl28_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl28_P" 
                                                        data-title="Enter Tgl.28 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl28_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl28_S">
                                                    <span  data-value="<?php echo $data['tgl28_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl28_S" 
                                                        data-title="Enter Tgl.28 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl28_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl29_P">
                                                    <span  data-value="<?php echo $data['tgl29_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl29_P" 
                                                        data-title="Enter Tgl.29 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl29_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl29_S">
                                                    <span  data-value="<?php echo $data['tgl29_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl29_S" 
                                                        data-title="Enter Tgl.29 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl29_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl30_P">
                                                    <span  data-value="<?php echo $data['tgl30_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl30_P" 
                                                        data-title="Enter Tgl.30 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl30_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl30_S">
                                                    <span  data-value="<?php echo $data['tgl30_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl30_S" 
                                                        data-title="Enter Tgl.30 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl30_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl31_P">
                                                    <span  data-value="<?php echo $data['tgl31_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl31_P" 
                                                        data-title="Enter Tgl.31 Pagi" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl31_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl31_S">
                                                    <span  data-value="<?php echo $data['tgl31_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_januari/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl31_S" 
                                                        data-title="Enter Tgl.31 Sore" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['tgl31_S']; ?> 
                                                    </span>
                                                </td>
                                                <th class="td-btn">
                                                    <a class="btn btn-sm btn-success has-tooltip" title="View Record" href="<?php print_link("bulan_januari/view/$rec_id"); ?>">
                                                        <i class="fa fa-eye"></i> View
                                                    </a>
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("bulan_januari/edit/$rec_id"); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <a class="btn btn-sm btn-danger has-tooltip record-delete-btn" title="Delete this record" href="<?php print_link("bulan_januari/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                        <i class="fa fa-times"></i>
                                                        Delete
                                                    </a>
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="fa fa-ban"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                                <button data-prompt-msg="Are you sure you want to delete these records?" data-display-style="modal" data-url="<?php print_link("bulan_januari/delete/{sel_ids}/?csrf_token=$csrf_token&redirect=$current_page"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                    <i class="fa fa-times"></i> Delete Selected
                                                </button>
                                                <div class="dropup export-btn-holder mx-1">
                                                    <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        <i class="fa fa-save"></i> Export
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                        <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                                            </a>
                                                            <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                                            <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                                                <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                                                </a>
                                                                <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                                                <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                                    <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                                    </a>
                                                                    <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                                    <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                                        <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                                        </a>
                                                                        <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                                        <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                                            <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col">   
                                                                <?php
                                                                if($show_pagination == true){
                                                                $pager = new Pagination($total_records, $record_count);
                                                                $pager->route = $this->route;
                                                                $pager->show_page_count = true;
                                                                $pager->show_record_count = true;
                                                                $pager->show_page_limit =true;
                                                                $pager->limit_count = $this->limit_count;
                                                                $pager->show_page_number_list = true;
                                                                $pager->pager_link_range=5;
                                                                $pager->render();
                                                                }
                                                                ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
