<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("bulan_september/add");
$can_edit = ACL::is_allowed("bulan_september/edit");
$can_view = ACL::is_allowed("bulan_september/view");
$can_delete = ACL::is_allowed("bulan_september/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Absensi Bulan September</h4>
                </div>
                <div class="col-sm-3 ">
                    <?php if($can_add){ ?>
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("bulan_september/add") ?>">
                        <i class="fa fa-plus"></i>                              
                        Tambah Pegawai 
                    </a>
                    <?php } ?>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('bulan_september'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('bulan_september'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('bulan_september'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="bulan_september-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <table class="table  table-striped table-sm text-left table-bordered">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-sno">#</th>
                                                <th  class="td-nama"> Nama</th>
                                                <th  class="td-nip"> NIP / NIPK</th>
                                                <th  class="td-tgl1_P"> Tgl.1 P</th>
                                                <th  class="td-tgl1_S"> Tgl.1 S</th>
                                                <th  class="td-tgl2_P"> Tgl.2 P</th>
                                                <th  class="td-tgl2_S"> Tgl.2 S</th>
                                                <th  class="td-tgl3_P"> Tgl.3 P</th>
                                                <th  class="td-tgl3_S"> Tgl.3 S</th>
                                                <th  class="td-tgl4_P"> Tgl.4 P</th>
                                                <th  class="td-tgl4_S"> Tgl.4 S</th>
                                                <th  class="td-tgl5_P"> Tgl.5 P</th>
                                                <th  class="td-tgl5_S"> Tgl.5 S</th>
                                                <th  class="td-tgl6_P"> Tgl.6 P</th>
                                                <th  class="td-tgl6_S"> Tgl.6 S</th>
                                                <th  class="td-tgl7_P"> Tgl.7 P</th>
                                                <th  class="td-tgl7_S"> Tgl.7 S</th>
                                                <th  class="td-tgl8_P"> Tgl.8 P</th>
                                                <th  class="td-tgl8_S"> Tgl.8 S</th>
                                                <th  class="td-tgl9_P"> Tgl.9 P</th>
                                                <th  class="td-tgl9_S"> Tgl.9 S</th>
                                                <th  class="td-tgl10_P"> Tgl.10 P</th>
                                                <th  class="td-tgl10_S"> Tgl.10 S</th>
                                                <th  class="td-tgl11_P"> Tgl.11 P</th>
                                                <th  class="td-tgl11_S"> Tgl.11 S</th>
                                                <th  class="td-tgl12_P"> Tgl.12 P</th>
                                                <th  class="td-tgl12_S"> Tgl.12 S</th>
                                                <th  class="td-tgl13_P"> Tgl.13 P</th>
                                                <th  class="td-tgl13_S"> Tgl.13 S</th>
                                                <th  class="td-tgl14_P"> Tgl.14 P</th>
                                                <th  class="td-tgl14_S"> Tgl.14 S</th>
                                                <th  class="td-tgl15_P"> Tgl.15 P</th>
                                                <th  class="td-tgl15_S"> Tgl.15 S</th>
                                                <th  class="td-tgl16_P"> Tgl.16 P</th>
                                                <th  class="td-tgl16_S"> Tgl.16 S</th>
                                                <th  class="td-tgl17_P"> Tgl.17 P</th>
                                                <th  class="td-tgl17_S"> Tgl.17 S</th>
                                                <th  class="td-tgl18_P"> Tgl.18 P</th>
                                                <th  class="td-tgl18_S"> Tgl.18 S</th>
                                                <th  class="td-tgl19_P"> Tgl.19 P</th>
                                                <th  class="td-tgl19_S"> Tgl.19 S</th>
                                                <th  class="td-tgl20_P"> Tgl.20 P</th>
                                                <th  class="td-tgl20_S"> Tgl.20 S</th>
                                                <th  class="td-tgl21_P"> Tgl.21 P</th>
                                                <th  class="td-tgl21_S"> Tgl.21 S</th>
                                                <th  class="td-tgl22_P"> Tgl.22 P</th>
                                                <th  class="td-tgl22_S"> Tgl.22 S</th>
                                                <th  class="td-tgl23_P"> Tgl.23 P</th>
                                                <th  class="td-tgl23_S"> Tgl.23 S</th>
                                                <th  class="td-tgl24_P"> Tgl.24 P</th>
                                                <th  class="td-tgl24_S"> Tgl.24 S</th>
                                                <th  class="td-tgl25_P"> Tgl.25 P</th>
                                                <th  class="td-tgl25_S"> Tgl.25 S</th>
                                                <th  class="td-tgl26_P"> Tgl.26 P</th>
                                                <th  class="td-tgl26_S"> Tgl.26 S</th>
                                                <th  class="td-tgl27_P"> Tgl.27 P</th>
                                                <th  class="td-tgl27_S"> Tgl.27 S</th>
                                                <th  class="td-tgl28_P"> Tgl.28 P</th>
                                                <th  class="td-tgl28_S"> Tgl.28 S</th>
                                                <th  class="td-tgl29_P"> Tgl.29 P</th>
                                                <th  class="td-tgl29_S"> Tgl.29 S</th>
                                                <th  class="td-tgl30_P"> Tgl.30 P</th>
                                                <th  class="td-tgl30_S"> Tgl.30 S</th>
                                                <th  class="td-tgl31_P"> Tgl.31 P</th>
                                                <th  class="td-tgl31_S"> Tgl.31 S</th>
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['id']) ? urlencode($data['id']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-sno"><?php echo $counter; ?></th>
                                                <td class="td-nama">
                                                    <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/bulan_september_nama_option_list'); ?>' 
                                                        data-value="<?php echo $data['nama']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="nama" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['nama']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-nip">
                                                    <span <?php if($can_edit){ ?> data-source='<?php 
                                                        $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                        print_link('api/json/bulan_september_nip_option_list/'.$dependent_field); 
                                                        ?>' 
                                                        data-value="<?php echo $data['nip']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="nip" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['nip']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl1_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl1_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl1_P" 
                                                        data-title="Enter Tgl.1 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl1_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl1_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl1_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl1_S" 
                                                        data-title="Enter Tgl.1 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl1_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl2_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl2_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl2_P" 
                                                        data-title="Enter Tgl.2 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl2_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl2_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl2_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl2_S" 
                                                        data-title="Enter Tgl.2 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl2_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl3_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl3_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl3_P" 
                                                        data-title="Enter Tgl.3 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl3_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl3_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl3_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl3_S" 
                                                        data-title="Enter Tgl.3 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl3_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl4_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl4_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl4_P" 
                                                        data-title="Enter Tgl.4 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl4_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl4_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl4_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl4_S" 
                                                        data-title="Enter Tgl.4 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl4_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl5_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl5_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl5_P" 
                                                        data-title="Enter Tgl.5 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl5_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl5_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl5_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl5_S" 
                                                        data-title="Enter Tgl.5 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl5_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl6_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl6_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl6_P" 
                                                        data-title="Enter Tgl.6 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl6_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl6_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl6_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl6_S" 
                                                        data-title="Enter Tgl.6 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl6_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl7_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl7_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl7_P" 
                                                        data-title="Enter Tgl.7 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl7_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl7_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl7_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl7_S" 
                                                        data-title="Enter Tgl.7 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl7_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl8_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl8_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl8_P" 
                                                        data-title="Enter Tgl.8 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl8_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl8_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl8_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl8_S" 
                                                        data-title="Enter Tgl.8 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl8_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl9_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl9_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl9_P" 
                                                        data-title="Enter Tgl.9 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl9_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl9_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl9_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl9_S" 
                                                        data-title="Enter Tgl.9 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl9_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl10_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl10_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl10_P" 
                                                        data-title="Enter Tgl.10 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl10_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl10_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl10_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl10_S" 
                                                        data-title="Enter Tgl.10 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl10_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl11_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl11_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl11_P" 
                                                        data-title="Enter Tgl.11 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl11_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl11_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl11_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl11_S" 
                                                        data-title="Enter Tgl.11 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl11_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl12_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl12_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl12_P" 
                                                        data-title="Enter Tgl.12 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl12_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl12_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl12_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl12_S" 
                                                        data-title="Enter Tgl.12 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl12_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl13_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl13_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl13_P" 
                                                        data-title="Enter Tgl.13 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl13_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl13_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl13_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl13_S" 
                                                        data-title="Enter Tgl.13 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl13_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl14_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl14_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl14_P" 
                                                        data-title="Enter Tgl.14 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl14_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl14_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl14_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl14_S" 
                                                        data-title="Enter Tgl.14 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl14_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl15_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl15_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl15_P" 
                                                        data-title="Enter Tgl.15 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl15_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl15_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl15_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl15_S" 
                                                        data-title="Enter Tgl.15 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl15_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl16_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl16_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl16_P" 
                                                        data-title="Enter Tgl.16 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl16_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl16_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl16_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl16_S" 
                                                        data-title="Enter Tgl.16 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl16_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl17_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl17_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl17_P" 
                                                        data-title="Enter Tgl.17 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl17_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl17_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl17_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl17_S" 
                                                        data-title="Enter Tgl.17 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl17_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl18_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl18_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl18_P" 
                                                        data-title="Enter Tgl.18 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl18_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl18_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl18_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl18_S" 
                                                        data-title="Enter Tgl.18 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl18_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl19_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl19_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl19_P" 
                                                        data-title="Enter Tgl.19 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl19_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl19_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl19_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl19_S" 
                                                        data-title="Enter Tgl.19 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl19_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl20_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl20_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl20_P" 
                                                        data-title="Enter Tgl.20 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl20_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl20_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl20_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl20_S" 
                                                        data-title="Enter Tgl.20 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl20_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl21_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl21_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl21_P" 
                                                        data-title="Enter Tgl.21 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl21_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl21_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl21_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl21_S" 
                                                        data-title="Enter Tgl.21 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl21_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl22_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl22_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl22_P" 
                                                        data-title="Enter Tgl.22 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl22_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl22_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl22_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl22_S" 
                                                        data-title="Enter Tgl.22 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl22_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl23_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl23_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl23_P" 
                                                        data-title="Enter Tgl.23 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl23_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl23_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl23_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl23_S" 
                                                        data-title="Enter Tgl.23 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl23_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl24_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl24_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl24_P" 
                                                        data-title="Enter Tgl.24 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl24_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl24_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl24_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl24_S" 
                                                        data-title="Enter Tgl.24 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl24_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl25_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl25_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl25_P" 
                                                        data-title="Enter Tgl.25 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl25_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl25_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl25_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl25_S" 
                                                        data-title="Enter Tgl.25 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl25_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl26_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl26_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl26_P" 
                                                        data-title="Enter Tgl.26 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl26_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl26_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl26_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl26_S" 
                                                        data-title="Enter Tgl.26 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl26_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl27_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl27_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl27_P" 
                                                        data-title="Enter Tgl.27 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl27_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl27_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl27_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl27_S" 
                                                        data-title="Enter Tgl.27 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl27_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl28_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl28_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl28_P" 
                                                        data-title="Enter Tgl.28 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl28_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl28_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl28_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl28_S" 
                                                        data-title="Enter Tgl.28 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl28_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl29_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl29_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl29_P" 
                                                        data-title="Enter Tgl.29 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl29_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl29_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl29_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl29_S" 
                                                        data-title="Enter Tgl.29 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl29_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl30_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl30_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl30_P" 
                                                        data-title="Enter Tgl.30 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl30_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl30_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl30_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl30_S" 
                                                        data-title="Enter Tgl.30 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl30_S']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl31_P">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl31_P']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl31_P" 
                                                        data-title="Enter Tgl.31 P" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl31_P']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl31_S">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tgl31_S']; ?>" 
                                                        data-pk="<?php echo $data['id'] ?>" 
                                                        data-url="<?php print_link("bulan_september/editfield/" . urlencode($data['id'])); ?>" 
                                                        data-name="tgl31_S" 
                                                        data-title="Enter Tgl.31 S" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl31_S']; ?> 
                                                    </span>
                                                </td>
                                                <th class="td-btn">
                                                    <?php if($can_edit){ ?>
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("bulan_september/edit/$rec_id"); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <?php } ?>
                                                    <?php if($can_delete){ ?>
                                                    <a class="btn btn-sm btn-danger has-tooltip record-delete-btn" title="Delete this record" href="<?php print_link("bulan_september/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                        <i class="fa fa-times"></i>
                                                        Delete
                                                    </a>
                                                    <?php } ?>
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="fa fa-ban"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                                <?php if($can_delete){ ?>
                                                <button data-prompt-msg="Are you sure you want to delete these records?" data-display-style="modal" data-url="<?php print_link("bulan_september/delete/{sel_ids}/?csrf_token=$csrf_token&redirect=$current_page"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                    <i class="fa fa-times"></i> Delete Selected
                                                </button>
                                                <?php } ?>
                                                <div class="dropup export-btn-holder mx-1">
                                                    <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        <i class="fa fa-save"></i> Export
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                        <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                                            </a>
                                                            <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                                            <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                                                <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                                                </a>
                                                                <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                                                <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                                    <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                                    </a>
                                                                    <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                                    <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                                        <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                                        </a>
                                                                        <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                                        <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                                            <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col">   
                                                                <?php
                                                                if($show_pagination == true){
                                                                $pager = new Pagination($total_records, $record_count);
                                                                $pager->route = $this->route;
                                                                $pager->show_page_count = true;
                                                                $pager->show_record_count = true;
                                                                $pager->show_page_limit =true;
                                                                $pager->limit_count = $this->limit_count;
                                                                $pager->show_page_number_list = true;
                                                                $pager->pager_link_range=5;
                                                                $pager->render();
                                                                }
                                                                ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
