<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("ckg/add");
$can_edit = ACL::is_allowed("ckg/edit");
$can_view = ACL::is_allowed("ckg/view");
$can_delete = ACL::is_allowed("ckg/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "view-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data Information from Controller
$data = $this->view_data;
//$rec_id = $data['__tableprimarykey'];
$page_id = $this->route->page_id; //Page id from url
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_edit_btn = $this->show_edit_btn;
$show_delete_btn = $this->show_delete_btn;
$show_export_btn = $this->show_export_btn;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="view"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">View Laporan CKG</h4>
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class="card animated fadeIn page-content">
                        <?php
                        $counter = 0;
                        if(!empty($data)){
                        $rec_id = (!empty($data['id_ckg']) ? urlencode($data['id_ckg']) : null);
                        $counter++;
                        ?>
                        <div id="page-report-body" class="">
                            <table class="table table-hover table-borderless table-striped">
                                <!-- Table Body Start -->
                                <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                    <tr  class="td-tgl_lapor">
                                        <th class="title"> Tgl. Laporan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_lapor']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="tgl_lapor" 
                                                data-title="Enter Tgl. Laporan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_lapor']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-target">
                                        <th class="title"> Target: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['target']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="target" 
                                                data-title="Enter Target" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['target']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-bulan">
                                        <th class="title"> Bulan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php echo json_encode_quote(Menu :: $bulan); ?>' 
                                                data-value="<?php echo $data['bulan']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="bulan" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['bulan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-bayi">
                                        <th class="title"> Bayi: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['bayi']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="bayi" 
                                                data-title="Enter Bayi" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['bayi']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-anak">
                                        <th class="title"> Anak: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['anak']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="anak" 
                                                data-title="Enter Anak" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['anak']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-sd">
                                        <th class="title"> SD: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['sd']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="sd" 
                                                data-title="Enter SD" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['sd']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-smp">
                                        <th class="title"> SMP: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['smp']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="smp" 
                                                data-title="Enter SMP" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['smp']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-sma">
                                        <th class="title"> SMA: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['sma']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="sma" 
                                                data-title="Enter SMA" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['sma']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-dewasa_I">
                                        <th class="title"> Dewasa I: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['dewasa_I']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="dewasa_I" 
                                                data-title="Enter Dewasa I" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['dewasa_I']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-dewasa_II">
                                        <th class="title"> Dewasa II: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['dewasa_II']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="dewasa_II" 
                                                data-title="Enter Dewasa II" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['dewasa_II']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-dewasa_III">
                                        <th class="title"> Dewasa III: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['dewasa_III']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="dewasa_III" 
                                                data-title="Enter Dewasa III" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['dewasa_III']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-lansia">
                                        <th class="title"> Lansia: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['lansia']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="lansia" 
                                                data-title="Enter Lansia" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['lansia']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-jumlah_diperiksa">
                                        <th class="title"> Jumlah Diperiksa: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['jumlah_diperiksa']; ?>" 
                                                data-pk="<?php echo $data['id_ckg'] ?>" 
                                                data-url="<?php print_link("ckg/editfield/" . urlencode($data['id_ckg'])); ?>" 
                                                data-name="jumlah_diperiksa" 
                                                data-title="Enter Jumlah Diperiksa" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['jumlah_diperiksa']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                                <!-- Table Body End -->
                            </table>
                        </div>
                        <div class="p-3 d-flex">
                            <div class="dropup export-btn-holder mx-1">
                                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-save"></i> Export
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                    <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                        <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                        </a>
                                        <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                        <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                            <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                            </a>
                                            <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                            <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                </a>
                                                <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                    <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                    </a>
                                                    <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                    <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                        <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                        </a>
                                                    </div>
                                                </div>
                                                <?php if($can_edit){ ?>
                                                <a class="btn btn-sm btn-info"  href="<?php print_link("ckg/edit/$rec_id"); ?>">
                                                    <i class="fa fa-edit"></i> Edit
                                                </a>
                                                <?php } ?>
                                                <?php if($can_delete){ ?>
                                                <a class="btn btn-sm btn-danger record-delete-btn mx-1"  href="<?php print_link("ckg/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                    <i class="fa fa-times"></i> Delete
                                                </a>
                                                <?php } ?>
                                            </div>
                                            <?php
                                            }
                                            else{
                                            ?>
                                            <!-- Empty Record Message -->
                                            <div class="text-muted p-3">
                                                <i class="fa fa-ban"></i> No Record Found
                                            </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
