<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("klaster4/add");
$can_edit = ACL::is_allowed("klaster4/edit");
$can_view = ACL::is_allowed("klaster4/view");
$can_delete = ACL::is_allowed("klaster4/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Data Klaster 4</h4>
                </div>
                <div class="col-sm-3 ">
                    <?php if($can_add){ ?>
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("klaster4/add") ?>">
                        <i class="fa fa-plus"></i>                              
                        Tambah Data 
                    </a>
                    <?php } ?>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('klaster4'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('klaster4'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('klaster4'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="klaster4-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <table class="table  table-striped table-sm text-left table-bordered">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-sno">#</th>
                                                <th  class="td-kategori"> Kategori</th>
                                                <th  class="td-indikator"> Indikator</th>
                                                <th  class="td-target"> Target</th>
                                                <th  class="td-denominator"> Denom</th>
                                                <th  class="td-januari"> Januari</th>
                                                <th  class="td-februari"> Februari</th>
                                                <th  class="td-maret"> Maret</th>
                                                <th  class="td-april"> April</th>
                                                <th  class="td-mei"> Mei</th>
                                                <th  class="td-juni"> Juni</th>
                                                <th  class="td-juli"> Juli</th>
                                                <th  class="td-agustus"> Agustus</th>
                                                <th  class="td-september"> September</th>
                                                <th  class="td-oktober"> Oktober</th>
                                                <th  class="td-november"> November</th>
                                                <th  class="td-desember"> Desember</th>
                                                <th  class="td-jumlah"> Jumlah</th>
                                                <th  class="td-capaian"> Capaian</th>
                                                <th  class="td-analisis"> Analisa Masalah</th>
                                                <th  class="td-rtl"> Rencana Tindak Lanjut</th>
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['id_klaster4']) ? urlencode($data['id_klaster4']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-sno"><?php echo $counter; ?></th>
                                                <td class="td-kategori"> <?php echo $data['kategori']; ?></td>
                                                <td class="td-indikator"> <?php echo $data['indikator']; ?></td>
                                                <td class="td-target">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['target']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="target" 
                                                        data-title="Enter Target" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['target']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-denominator"> <?php echo $data['denominator']; ?></td>
                                                <td class="td-januari">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['januari']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="januari" 
                                                        data-title="Enter Januari" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['januari']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-februari">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['februari']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="februari" 
                                                        data-title="Enter Februari" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['februari']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-maret">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['maret']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="maret" 
                                                        data-title="Enter Maret" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['maret']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-april">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['april']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="april" 
                                                        data-title="Enter April" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['april']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-mei">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['mei']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="mei" 
                                                        data-title="Enter Mei" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['mei']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-juni">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['juni']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="juni" 
                                                        data-title="Enter Juni" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['juni']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-juli">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['juli']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="juli" 
                                                        data-title="Enter Juli" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['juli']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-agustus">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['agustus']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="agustus" 
                                                        data-title="Enter Agustus" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['agustus']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-september">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['september']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="september" 
                                                        data-title="Enter September" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['september']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-oktober">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['oktober']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="oktober" 
                                                        data-title="Enter Oktober" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['oktober']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-november">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['november']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="november" 
                                                        data-title="Enter November" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['november']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-desember">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['desember']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="desember" 
                                                        data-title="Enter Desember" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['desember']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-jumlah"> <?php echo $data['jumlah']; ?></td>
                                                <td class="td-capaian">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['capaian']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="capaian" 
                                                        data-title="Enter Capaian" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['capaian']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-analisis">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['analisis']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="analisis" 
                                                        data-title="Enter Analisis" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['analisis']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-rtl">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['rtl']; ?>" 
                                                        data-pk="<?php echo $data['id_klaster4'] ?>" 
                                                        data-url="<?php print_link("klaster4/editfield/" . urlencode($data['id_klaster4'])); ?>" 
                                                        data-name="rtl" 
                                                        data-title="Enter RTL" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['rtl']; ?> 
                                                    </span>
                                                </td>
                                                <th class="td-btn">
                                                    <?php if($can_edit){ ?>
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("klaster4/edit/$rec_id"); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <?php } ?>
                                                    <?php if($can_delete){ ?>
                                                    <a class="btn btn-sm btn-danger has-tooltip record-delete-btn" title="Delete this record" href="<?php print_link("klaster4/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                        <i class="fa fa-times"></i>
                                                        Delete
                                                    </a>
                                                    <?php } ?>
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="fa fa-ban"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                                <?php if($can_delete){ ?>
                                                <button data-prompt-msg="Are you sure you want to delete these records?" data-display-style="modal" data-url="<?php print_link("klaster4/delete/{sel_ids}/?csrf_token=$csrf_token&redirect=$current_page"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                    <i class="fa fa-times"></i> Delete Selected
                                                </button>
                                                <?php } ?>
                                                <div class="dropup export-btn-holder mx-1">
                                                    <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        <i class="fa fa-save"></i> Export
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                        <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                                            </a>
                                                            <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                                            <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                                                <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                                                </a>
                                                                <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                                                <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                                    <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                                    </a>
                                                                    <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                                    <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                                        <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                                        </a>
                                                                        <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                                        <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                                            <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col">   
                                                                <?php
                                                                if($show_pagination == true){
                                                                $pager = new Pagination($total_records, $record_count);
                                                                $pager->route = $this->route;
                                                                $pager->show_page_count = true;
                                                                $pager->show_record_count = true;
                                                                $pager->show_page_limit =true;
                                                                $pager->limit_count = $this->limit_count;
                                                                $pager->show_page_number_list = true;
                                                                $pager->pager_link_range=5;
                                                                $pager->render();
                                                                }
                                                                ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
