<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("pangkat/add");
$can_edit = ACL::is_allowed("pangkat/edit");
$can_view = ACL::is_allowed("pangkat/view");
$can_delete = ACL::is_allowed("pangkat/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">DUK Pegawai</h4>
                </div>
                <div class="col-sm-3 ">
                    <?php if($can_add){ ?>
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("pangkat/add") ?>">
                        <i class="fa fa-plus"></i>                              
                        Tambah Data 
                    </a>
                    <?php } ?>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('pangkat'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="fa fa-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('pangkat'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('pangkat'); ?>">
                                            <i class="fa fa-angle-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="pangkat-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <table class="table  table-striped table-sm text-left table-bordered">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-sno">#</th>
                                                <th  class="td-nama"> Nama Pegawai</th>
                                                <th  class="td-jenis_kelamin"> Jenis Kelamin</th>
                                                <th  class="td-tempat"> Tempat Lahir</th>
                                                <th  class="td-tgl_lahir"> Tgl.Lahir</th>
                                                <th  class="td-nip"> NIP/ NIPK</th>
                                                <th  class="td-nik"> NIK/ KTP</th>
                                                <th  class="td-gol_pangkat"> Gol/ Pangkat</th>
                                                <th  class="td-eselon"> Status Pegawai</th>
                                                <th  class="td-jabatan"> Jabatan</th>
                                                <th  class="td-tmt_cpns"> TMT CPNS</th>
                                                <th  class="td-tmt_puskesmas"> TMT Puskesmas</th>
                                                <th  class="td-no_str"> No. STR</th>
                                                <th  class="td-tgl_terbitstr"> Tgl. Terbit STR</th>
                                                <th  class="td-tgl_berlakustr"> Tgl. Berlaku STR</th>
                                                <th  class="td-no_sip"> No. SIP</th>
                                                <th  class="td-tgl_terbitsip"> Tgl. Terbit SIP</th>
                                                <th  class="td-tgl_berlakusip"> Tgl. Berlaku SIP</th>
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['id_pangkat']) ? urlencode($data['id_pangkat']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-sno"><?php echo $counter; ?></th>
                                                <td class="td-nama">
                                                    <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/pangkat_nama_option_list'); ?>' 
                                                        data-value="<?php echo $data['nama']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="nama" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['nama']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-jenis_kelamin">
                                                    <span <?php if($can_edit){ ?> data-source='<?php echo json_encode_quote(Menu :: $jenis_kelamin); ?>' 
                                                        data-value="<?php echo $data['jenis_kelamin']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="jenis_kelamin" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['jenis_kelamin']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tempat">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['tempat']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="tempat" 
                                                        data-title="Enter Tempat Lahir" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tempat']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_lahir">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['tgl_lahir']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="tgl_lahir" 
                                                        data-title="Enter Tgl. Lahir" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_lahir']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-nip">
                                                    <span <?php if($can_edit){ ?> data-source='<?php 
                                                        $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                        print_link('api/json/pangkat_nip_option_list/'.$dependent_field); 
                                                        ?>' 
                                                        data-value="<?php echo $data['nip']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="nip" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['nip']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-nik">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['nik']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="nik" 
                                                        data-title="Enter NIK-KTP" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['nik']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-gol_pangkat">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['gol_pangkat']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="gol_pangkat" 
                                                        data-title="Enter Gol/ Pangkat" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['gol_pangkat']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-eselon">
                                                    <span <?php if($can_edit){ ?> data-source='<?php echo json_encode_quote(Menu :: $eselon); ?>' 
                                                        data-value="<?php echo $data['eselon']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="eselon" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['eselon']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-jabatan">
                                                    <span <?php if($can_edit){ ?> data-source='<?php 
                                                        $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                        print_link('api/json/pangkat_jabatan_option_list/'.$dependent_field); 
                                                        ?>' 
                                                        data-value="<?php echo $data['jabatan']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="jabatan" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['jabatan']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tmt_cpns">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['tmt_cpns']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="tmt_cpns" 
                                                        data-title="Enter TMT CPNS" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tmt_cpns']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tmt_puskesmas">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['tmt_puskesmas']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="tmt_puskesmas" 
                                                        data-title="Enter TMT Puskesmas" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tmt_puskesmas']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-no_str">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['no_str']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="no_str" 
                                                        data-title="Enter No. STR" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['no_str']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_terbitstr">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['tgl_terbitstr']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="tgl_terbitstr" 
                                                        data-title="Enter Tgl. Terbit STR" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_terbitstr']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_berlakustr">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['tgl_berlakustr']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="tgl_berlakustr" 
                                                        data-title="Enter Tgl. Berlaku STR" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_berlakustr']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-no_sip">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['no_sip']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="no_sip" 
                                                        data-title="Enter No. SIP" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['no_sip']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_terbitsip">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['tgl_terbitsip']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="tgl_terbitsip" 
                                                        data-title="Enter Tgl. Terbit SIP" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_terbitsip']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-tgl_berlakusip">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['tgl_berlakusip']; ?>" 
                                                        data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                        data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                        data-name="tgl_berlakusip" 
                                                        data-title="Enter Tgl. Berlaku SIP" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['tgl_berlakusip']; ?> 
                                                    </span>
                                                </td>
                                                <th class="td-btn">
                                                    <?php if($can_view){ ?>
                                                    <a class="btn btn-sm btn-success has-tooltip" title="View Record" href="<?php print_link("pangkat/view/$rec_id"); ?>">
                                                        <i class="fa fa-eye"></i> View
                                                    </a>
                                                    <?php } ?>
                                                    <?php if($can_edit){ ?>
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("pangkat/edit/$rec_id"); ?>">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <?php } ?>
                                                    <?php if($can_delete){ ?>
                                                    <a class="btn btn-sm btn-danger has-tooltip record-delete-btn" title="Delete this record" href="<?php print_link("pangkat/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                        <i class="fa fa-times"></i>
                                                        Delete
                                                    </a>
                                                    <?php } ?>
                                                </th>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="fa fa-ban"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                                <?php if($can_delete){ ?>
                                                <button data-prompt-msg="Are you sure you want to delete these records?" data-display-style="modal" data-url="<?php print_link("pangkat/delete/{sel_ids}/?csrf_token=$csrf_token&redirect=$current_page"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                    <i class="fa fa-times"></i> Delete Selected
                                                </button>
                                                <?php } ?>
                                                <div class="dropup export-btn-holder mx-1">
                                                    <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        <i class="fa fa-save"></i> Export
                                                    </button>
                                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                        <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                                        <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                                            <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                                            </a>
                                                            <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                                            <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                                                <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                                                </a>
                                                                <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                                                <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                                    <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                                    </a>
                                                                    <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                                    <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                                        <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                                        </a>
                                                                        <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                                        <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                                            <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col">   
                                                                <?php
                                                                if($show_pagination == true){
                                                                $pager = new Pagination($total_records, $record_count);
                                                                $pager->route = $this->route;
                                                                $pager->show_page_count = true;
                                                                $pager->show_record_count = true;
                                                                $pager->show_page_limit =true;
                                                                $pager->limit_count = $this->limit_count;
                                                                $pager->show_page_number_list = true;
                                                                $pager->pager_link_range=5;
                                                                $pager->render();
                                                                }
                                                                ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
