<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("pangkat/add");
$can_edit = ACL::is_allowed("pangkat/edit");
$can_view = ACL::is_allowed("pangkat/view");
$can_delete = ACL::is_allowed("pangkat/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "view-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data Information from Controller
$data = $this->view_data;
//$rec_id = $data['__tableprimarykey'];
$page_id = $this->route->page_id; //Page id from url
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_edit_btn = $this->show_edit_btn;
$show_delete_btn = $this->show_delete_btn;
$show_export_btn = $this->show_export_btn;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="view"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">View DUK Pegawai</h4>
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class="card animated fadeIn page-content">
                        <?php
                        $counter = 0;
                        if(!empty($data)){
                        $rec_id = (!empty($data['id_pangkat']) ? urlencode($data['id_pangkat']) : null);
                        $counter++;
                        ?>
                        <div id="page-report-body" class="">
                            <table class="table table-hover table-borderless table-striped">
                                <!-- Table Body Start -->
                                <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                    <tr  class="td-nama">
                                        <th class="title"> Nama Pegawai: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/pangkat_nama_option_list'); ?>' 
                                                data-value="<?php echo $data['nama']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="nama" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nama']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-jenis_kelamin">
                                        <th class="title"> Jenis Kelamin: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php echo json_encode_quote(Menu :: $jenis_kelamin); ?>' 
                                                data-value="<?php echo $data['jenis_kelamin']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="jenis_kelamin" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['jenis_kelamin']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tempat">
                                        <th class="title"> Tempat Lahir: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['tempat']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="tempat" 
                                                data-title="Enter Tempat Lahir" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tempat']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tgl_lahir">
                                        <th class="title"> Tgl. Lahir: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_lahir']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="tgl_lahir" 
                                                data-title="Enter Tgl. Lahir" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_lahir']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-nip">
                                        <th class="title"> NIP / NIPK: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php 
                                                $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                print_link('api/json/pangkat_nip_option_list/'.$dependent_field); 
                                                ?>' 
                                                data-value="<?php echo $data['nip']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="nip" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nip']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-nik">
                                        <th class="title"> NIK-KTP: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['nik']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="nik" 
                                                data-title="Enter NIK-KTP" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nik']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-gol_pangkat">
                                        <th class="title"> Gol/ Pangkat: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['gol_pangkat']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="gol_pangkat" 
                                                data-title="Enter Gol/ Pangkat" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['gol_pangkat']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-eselon">
                                        <th class="title"> Status Pegawai: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php echo json_encode_quote(Menu :: $eselon); ?>' 
                                                data-value="<?php echo $data['eselon']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="eselon" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['eselon']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-jabatan">
                                        <th class="title"> Jabatan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php 
                                                $dependent_field = (!empty($data['nama']) ? urlencode($data['nama']) : null);
                                                print_link('api/json/pangkat_jabatan_option_list/'.$dependent_field); 
                                                ?>' 
                                                data-value="<?php echo $data['jabatan']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="jabatan" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['jabatan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tmt_cpns">
                                        <th class="title"> TMT CPNS: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tmt_cpns']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="tmt_cpns" 
                                                data-title="Enter TMT CPNS" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tmt_cpns']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tmt_puskesmas">
                                        <th class="title"> TMT Puskesmas: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tmt_puskesmas']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="tmt_puskesmas" 
                                                data-title="Enter TMT Puskesmas" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tmt_puskesmas']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-no_str">
                                        <th class="title"> No. STR: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['no_str']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="no_str" 
                                                data-title="Enter No. STR" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['no_str']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tgl_terbitstr">
                                        <th class="title"> Tgl. Terbit STR: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_terbitstr']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="tgl_terbitstr" 
                                                data-title="Enter Tgl. Terbit STR" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_terbitstr']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tgl_berlakustr">
                                        <th class="title"> Tgl. Berlaku STR: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_berlakustr']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="tgl_berlakustr" 
                                                data-title="Enter Tgl. Berlaku STR" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_berlakustr']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-no_sip">
                                        <th class="title"> No. SIP: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['no_sip']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="no_sip" 
                                                data-title="Enter No. SIP" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['no_sip']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tgl_terbitsip">
                                        <th class="title"> Tgl Terbit SIP: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_terbitsip']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="tgl_terbitsip" 
                                                data-title="Enter Tgl. Terbit SIP" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_terbitsip']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tgl_berlakusip">
                                        <th class="title"> Tgl. Berlaku SIP: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_berlakusip']; ?>" 
                                                data-pk="<?php echo $data['id_pangkat'] ?>" 
                                                data-url="<?php print_link("pangkat/editfield/" . urlencode($data['id_pangkat'])); ?>" 
                                                data-name="tgl_berlakusip" 
                                                data-title="Enter Tgl. Berlaku SIP" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_berlakusip']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                                <!-- Table Body End -->
                            </table>
                        </div>
                        <div class="p-3 d-flex">
                            <div class="dropup export-btn-holder mx-1">
                                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-save"></i> Export
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                    <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                        <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                        </a>
                                        <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                        <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                            <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                            </a>
                                            <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                            <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                </a>
                                                <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                    <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                    </a>
                                                    <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                    <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                        <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                        </a>
                                                    </div>
                                                </div>
                                                <?php if($can_edit){ ?>
                                                <a class="btn btn-sm btn-info"  href="<?php print_link("pangkat/edit/$rec_id"); ?>">
                                                    <i class="fa fa-edit"></i> Edit
                                                </a>
                                                <?php } ?>
                                                <?php if($can_delete){ ?>
                                                <a class="btn btn-sm btn-danger record-delete-btn mx-1"  href="<?php print_link("pangkat/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                    <i class="fa fa-times"></i> Delete
                                                </a>
                                                <?php } ?>
                                            </div>
                                            <?php
                                            }
                                            else{
                                            ?>
                                            <!-- Empty Record Message -->
                                            <div class="text-muted p-3">
                                                <i class="fa fa-ban"></i> No Record Found
                                            </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
