<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("pengadaan/add");
$can_edit = ACL::is_allowed("pengadaan/edit");
$can_view = ACL::is_allowed("pengadaan/view");
$can_delete = ACL::is_allowed("pengadaan/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "view-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data Information from Controller
$data = $this->view_data;
//$rec_id = $data['__tableprimarykey'];
$page_id = $this->route->page_id; //Page id from url
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_edit_btn = $this->show_edit_btn;
$show_delete_btn = $this->show_delete_btn;
$show_export_btn = $this->show_export_btn;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="view"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">View Pengadaan Barang</h4>
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class="card animated fadeIn page-content">
                        <?php
                        $counter = 0;
                        if(!empty($data)){
                        $rec_id = (!empty($data['id_inventaris']) ? urlencode($data['id_inventaris']) : null);
                        $counter++;
                        ?>
                        <div id="page-report-body" class="">
                            <table class="table table-hover table-borderless table-striped">
                                <!-- Table Body Start -->
                                <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                    <tr  class="td-tgl_terima">
                                        <th class="title"> Tgl. Terima: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_terima']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="tgl_terima" 
                                                data-title="Enter Tgl Terima" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_terima']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-uraian">
                                        <th class="title"> Uraian Belanja: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/pengadaan_uraian_option_list'); ?>' 
                                                data-value="<?php echo $data['uraian']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="uraian" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['uraian']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-kodrek">
                                        <th class="title"> Kodrek Belanja: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php 
                                                $dependent_field = (!empty($data['uraian']) ? urlencode($data['uraian']) : null);
                                                print_link('api/json/pengadaan_kodrek_option_list/'.$dependent_field); 
                                                ?>' 
                                                data-value="<?php echo $data['kodrek']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="kodrek" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['kodrek']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-jenis">
                                        <th class="title"> Jenis Belanja: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/pengadaan_jenis_option_list'); ?>' 
                                                data-value="<?php echo $data['jenis']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="jenis" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['jenis']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-metode">
                                        <th class="title"> Metode Belanja: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/pengadaan_metode_option_list'); ?>' 
                                                data-value="<?php echo $data['metode']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="metode" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['metode']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-sumber">
                                        <th class="title"> Sumber Anggaran: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/pengadaan_sumber_option_list'); ?>' 
                                                data-value="<?php echo $data['sumber']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="sumber" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['sumber']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-nota_dinas">
                                        <th class="title"> Nota Dinas PPTK: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['nota_dinas']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="nota_dinas" 
                                                data-title="Enter Nota Dinas PPTK" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nota_dinas']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-nama">
                                        <th class="title"> Nama Barang: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['nama']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="nama" 
                                                data-title="Enter Nama" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nama']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-merk">
                                        <th class="title"> Merk: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['merk']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="merk" 
                                                data-title="Enter Merk" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['merk']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-spesifikasi">
                                        <th class="title"> Spesifikasi: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['spesifikasi']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="spesifikasi" 
                                                data-title="Enter Spesifikasi" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['spesifikasi']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-volume">
                                        <th class="title"> Volume: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['volume']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="volume" 
                                                data-title="Enter Volume" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['volume']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-satuan">
                                        <th class="title"> Satuan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/pengadaan_satuan_option_list'); ?>' 
                                                data-value="<?php echo $data['satuan']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="satuan" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['satuan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-harga">
                                        <th class="title"> Harga: </th>
                                        <td class="value"><?php echo number_format($data['harga'], 0, ',', '.') . ""; ?></td>
                                    </tr>
                                    <tr  class="td-total">
                                        <th class="title"> Total Biaya: </th>
                                        <td class="value"> <?php echo $data['total']; ?></td>
                                    </tr>
                                    <tr  class="td-status">
                                        <th class="title"> Status: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php echo json_encode_quote(Menu :: $status); ?>' 
                                                data-value="<?php echo $data['status']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="status" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['status']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-keterangan">
                                        <th class="title"> Keterangan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['keterangan']; ?>" 
                                                data-pk="<?php echo $data['id_inventaris'] ?>" 
                                                data-url="<?php print_link("pengadaan/editfield/" . urlencode($data['id_inventaris'])); ?>" 
                                                data-name="keterangan" 
                                                data-title="Enter Keterangan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['keterangan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                                <!-- Table Body End -->
                            </table>
                        </div>
                        <div class="p-3 d-flex">
                            <div class="dropup export-btn-holder mx-1">
                                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-save"></i> Export
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                    <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                        <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                        </a>
                                        <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                        <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                            <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                            </a>
                                            <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                            <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                </a>
                                                <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                    <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                    </a>
                                                    <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                    <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                        <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                        </a>
                                                    </div>
                                                </div>
                                                <?php if($can_edit){ ?>
                                                <a class="btn btn-sm btn-info"  href="<?php print_link("pengadaan/edit/$rec_id"); ?>">
                                                    <i class="fa fa-edit"></i> Edit
                                                </a>
                                                <?php } ?>
                                                <?php if($can_delete){ ?>
                                                <a class="btn btn-sm btn-danger record-delete-btn mx-1"  href="<?php print_link("pengadaan/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                    <i class="fa fa-times"></i> Delete
                                                </a>
                                                <?php } ?>
                                            </div>
                                            <?php
                                            }
                                            else{
                                            ?>
                                            <!-- Empty Record Message -->
                                            <div class="text-muted p-3">
                                                <i class="fa fa-ban"></i> No Record Found
                                            </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
