<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("tugas/add");
$can_edit = ACL::is_allowed("tugas/edit");
$can_view = ACL::is_allowed("tugas/view");
$can_delete = ACL::is_allowed("tugas/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "view-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data Information from Controller
$data = $this->view_data;
//$rec_id = $data['__tableprimarykey'];
$page_id = $this->route->page_id; //Page id from url
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_edit_btn = $this->show_edit_btn;
$show_delete_btn = $this->show_delete_btn;
$show_export_btn = $this->show_export_btn;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="view"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">View Laporan Tugas Kedinasan</h4>
                </div>
            </div>
        </div>
    </div>
    <?php
    }
    ?>
    <div  class="">
        <div class="container">
            <div class="row ">
                <div class="col-md-12 comp-grid">
                    <?php $this :: display_page_errors(); ?>
                    <div  class="card animated fadeIn page-content">
                        <?php
                        $counter = 0;
                        if(!empty($data)){
                        $rec_id = (!empty($data['id_tugas']) ? urlencode($data['id_tugas']) : null);
                        $counter++;
                        ?>
                        <div id="page-report-body" class="">
                            <table class="table table-hover table-borderless table-striped">
                                <!-- Table Body Start -->
                                <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                    <tr  class="td-tgl_lapor">
                                        <th class="title"> Tgl. Laporan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y H:i:s', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_lapor']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="tgl_lapor" 
                                                data-title="Enter Tgl. Laporan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_lapor']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-pegawai">
                                        <th class="title"> Pegawai Yang Ditugaskan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/tugas_pegawai_option_list'); ?>' 
                                                data-value="<?php echo $data['pegawai']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="pegawai" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['pegawai']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-nip">
                                        <th class="title"> NIP / NIPK: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php 
                                                $dependent_field = (!empty($data['pegawai']) ? urlencode($data['pegawai']) : null);
                                                print_link('api/json/tugas_nip_option_list/'.$dependent_field); 
                                                ?>' 
                                                data-value="<?php echo $data['nip']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="nip" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nip']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-nama_kegiatan">
                                        <th class="title"> Nama Kegiatan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['nama_kegiatan']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="nama_kegiatan" 
                                                data-title="Enter Nama Kegiatan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['nama_kegiatan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tgl_kegiatan">
                                        <th class="title"> Tgl Kegiatan: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-flatpickr="{altFormat: 'd-m-Y H:i:s', enableTime: false, minDate: '', maxDate: ''}" 
                                                data-value="<?php echo $data['tgl_kegiatan']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="tgl_kegiatan" 
                                                data-title="Enter Tgl Kegiatan" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="flatdatetimepicker" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tgl_kegiatan']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-mulai_pukul">
                                        <th class="title"> Mulai Pukul: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['mulai_pukul']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="mulai_pukul" 
                                                data-title="Enter Mulai Pukul" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="time" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['mulai_pukul']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-berakhir_pukul">
                                        <th class="title"> Berakhir Pukul: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['berakhir_pukul']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="berakhir_pukul" 
                                                data-title="Enter Berakhir Pukul" 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="time" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['berakhir_pukul']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-tempat">
                                        <th class="title"> Tempat: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['tempat']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="tempat" 
                                                data-title="Enter Tempat " 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['tempat']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-pembuat">
                                        <th class="title"> Pembuat: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/tugas_pembuat_option_list'); ?>' 
                                                data-value="<?php echo $data['pembuat']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="pembuat" 
                                                data-title="Select a value ..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="select" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['pembuat']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                    <tr  class="td-upload">
                                        <th class="title"> Upload Notulen: </th>
                                        <td class="value">
                                            <span <?php if($can_edit){ ?> data-value="<?php echo $data['upload']; ?>" 
                                                data-pk="<?php echo $data['id_tugas'] ?>" 
                                                data-url="<?php print_link("tugas/editfield/" . urlencode($data['id_tugas'])); ?>" 
                                                data-name="upload" 
                                                data-title="Browse..." 
                                                data-placement="left" 
                                                data-toggle="click" 
                                                data-type="text" 
                                                data-mode="popover" 
                                                data-showbuttons="left" 
                                                class="is-editable" <?php } ?>>
                                                <?php echo $data['upload']; ?> 
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                                <!-- Table Body End -->
                            </table>
                        </div>
                        <div class="p-3 d-flex">
                            <div class="dropup export-btn-holder mx-1">
                                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fa fa-save"></i> Export
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php $export_print_link = $this->set_current_page_link(array('format' => 'print')); ?>
                                    <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                        <img src="<?php print_link('assets/images/print.png') ?>" class="mr-2" /> PRINT
                                        </a>
                                        <?php $export_pdf_link = $this->set_current_page_link(array('format' => 'pdf')); ?>
                                        <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                            <img src="<?php print_link('assets/images/pdf.png') ?>" class="mr-2" /> PDF
                                            </a>
                                            <?php $export_word_link = $this->set_current_page_link(array('format' => 'word')); ?>
                                            <a class="dropdown-item export-link-btn" data-format="word" href="<?php print_link($export_word_link); ?>" target="_blank">
                                                <img src="<?php print_link('assets/images/doc.png') ?>" class="mr-2" /> WORD
                                                </a>
                                                <?php $export_csv_link = $this->set_current_page_link(array('format' => 'csv')); ?>
                                                <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                                                    <img src="<?php print_link('assets/images/csv.png') ?>" class="mr-2" /> CSV
                                                    </a>
                                                    <?php $export_excel_link = $this->set_current_page_link(array('format' => 'excel')); ?>
                                                    <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                                                        <img src="<?php print_link('assets/images/xsl.png') ?>" class="mr-2" /> EXCEL
                                                        </a>
                                                    </div>
                                                </div>
                                                <?php if($can_edit){ ?>
                                                <a class="btn btn-sm btn-info"  href="<?php print_link("tugas/edit/$rec_id"); ?>">
                                                    <i class="fa fa-edit"></i> Edit
                                                </a>
                                                <?php } ?>
                                                <?php if($can_delete){ ?>
                                                <a class="btn btn-sm btn-danger record-delete-btn mx-1"  href="<?php print_link("tugas/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                    <i class="fa fa-times"></i> Delete
                                                </a>
                                                <?php } ?>
                                            </div>
                                            <?php
                                            }
                                            else{
                                            ?>
                                            <!-- Empty Record Message -->
                                            <div class="text-muted p-3">
                                                <i class="fa fa-ban"></i> No Record Found
                                            </div>
                                            <?php
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
